/* ------------------------------------------------------------------------
 *	document.h  --  part of DownScript
 * ------------------------------------------------------------------------
 *
 *	Copyright (c) 1998-1999  Andrew Apted  <ajapted@netspace.net.au>
 *
 *	This program is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation; either version 2, or
 *	(at your option) any later version.
 *
 *	You should have received a copy of the GNU General Public
 *	License along with this program; see the file COPYING.  If
 *	not, write to the Free Software Foundation, Inc., 59 Temple
 *	Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * ------------------------------------------------------------------------
 */

#ifndef _DOWNSCRIPT_DOCUMENT_H
#define _DOWNSCRIPT_DOCUMENT_H

#include "list.h"
#include "page.h"
#include "output.h"
#include "document.h"


#define MAX_FONT_HEIGHT  1000

typedef struct doc_info
{
	/* public */

	int xfudge;	/* percent */
	int yfudge;	/* percent */

	int font_width;
	int font_height;
	int font_style;

	int num_pages;

	int height_normal;   /* calculated from histogram */
	
	int minimum_y;	/* calculated via add_to_histogram() */
	int maximum_y;

	/* private */

	List /* of page_info */ pages;

	int font_histogram[MAX_FONT_HEIGHT];

	int first_page;

} doc_info;


extern doc_info *new_document(int first_page, int xfudge, int yfudge);
extern void free_document(doc_info *doc);

extern void add_doc_page(doc_info *doc, page_info *pg, page_info *after);

extern void add_to_histogram(doc_info *doc, string_box *sb);
extern void analyse_histogram(doc_info *doc);
extern void update_y_bounds(doc_info *doc);

extern page_info *find_page(doc_info *doc, int page_num);
extern page_info *find_last_page(doc_info *doc);
extern page_info *get_next_page(doc_info *doc, page_info *pg);
extern page_info *get_prev_page(doc_info *doc, page_info *pg);

extern int change_xfudge(doc_info *doc, int delta);
extern int change_yfudge(doc_info *doc, int delta);

extern void write_document(doc_info *doc, output_info *outp);


#endif  /* _DOWNSCRIPT_DOCUMENT_H */
