/* ------------------------------------------------------------------------
 *	debug.h  --  part of DownScript
 * ------------------------------------------------------------------------
 *
 *	Copyright (c) 1998-1999  Andrew Apted  <ajapted@netspace.net.au>
 *
 *	This program is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation; either version 2, or
 *	(at your option) any later version.
 *
 *	You should have received a copy of the GNU General Public
 *	License along with this program; see the file COPYING.  If
 *	not, write to the Free Software Foundation, Inc., 59 Temple
 *	Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * ------------------------------------------------------------------------
 */

#ifndef _DOWNSCRIPT_DEBUG_H
#define _DOWNSCRIPT_DEBUG_H

#include <stdio.h>

#include "output.h"


extern void debug_init (lowlevel_info *lowlev);
extern void debug_exit (lowlevel_info *lowlev);
extern void debug_flush(lowlevel_info *lowlev);

extern void debug_begin_markup(lowlevel_info *lowlev, int markup);
extern void debug_end_markup  (lowlevel_info *lowlev, int markup);
extern void debug_change_style(lowlevel_info *lowlev, 
				int style, int old_style);

extern void debug_output_word(lowlevel_info *lowlev, char *word);
extern void debug_word_break (lowlevel_info *lowlev, int size);
extern void debug_line_break (lowlevel_info *lowlev);


#endif  /* _DOWNSCRIPT_DEBUG_H */
