/* ------------------------------------------------------------------------
 *	chars.c  --  part of DownScript
 * ------------------------------------------------------------------------
 *
 *	Copyright (C) 1998-1999  Andrew Apted  <ajapted@netspace.net.au>
 *
 *	This program is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation; either version 2, or
 *	(at your option) any later version.
 *
 *	You should have received a copy of the GNU General Public
 *	License along with this program; see the file COPYING.  If
 *	not, write to the Free Software Foundation, Inc., 59 Temple
 *	Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * ------------------------------------------------------------------------
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "chars.h"


char *lookup_special_char(unsigned char c)
{
	/* Result is ISO-8859-1 (Latin 1) */

	switch (c) {

		case 0013: case 0255: case 0335: return "ff";
		case 0014: case 0256: case 0336: return "fi";
		case 0015: case 0257: case 0337: return "fl";
		case 0016: case 0260:            return "ffi";

		/* bullet */
		case 0017: case 0245: case 0267: return "\267";

		case 0261:            return "-";
		case 0320: case 0321: return " -- ";
		case 0252: case 0322: return "``";
		case 0272: case 0323: return "''";
		           case 0324: return "`";
		           case 0325: return "'";
		
		case 0026: return "\265";     /* greek u */
		case 0030: return "(TM)";     /* trademark */

		case 0205: return "\326";     /* O umlaut */
		case 0232: return "\366";     /* o umlaut */
		case 0251: return "\251";     /* copyright */
		case 0277: return "\370";     /* o slash */
	}

	return "?";
}

void recode_string(char *dest, int max, char *src)
{
	max -= 2;  /* safety buffer */

	while (*src && (max > 1)) {
		
		if ((*src < 0040) || (*src >= 0177)) {

			char *spec = lookup_special_char(*src); src++;

			if (strlen(spec) >= max) {
				break;
			}

			while (*spec) {
				*dest++ = *spec++; max--;
			}

			continue;
		}

		*dest++ = *src++; max--;
	}

	*dest = 0;
}
