/* Chord/Note detection
 * Copyright (C) 1999 Jan Kneschke
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * You should have received a copy of the GNU General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <string.h>

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>

#include "soundnote.h"

const float notevalue[] = {
			261.625488, 277.182556, 293.664703,
			311.126923, 329.627502, 349.228180,
			369.994385, 391.995422, 415.304688,
			440.000000, 466.163788, 493.883362};
			
const char* notename[] = 
	{ "C","C#","D","D#","E","F","F#","G","G#","A","A#","B"};

saftNote::saftNote (float frequency) {
	if (frequency > 0) {
		freq = frequency;
	} else {
		freq = -1;
	}
	
	noteidx = -1;
	octave = 0;
	
	calc();
}

saftNote::~saftNote() {
	
}

const char *saftNote::getNote() {
	if (noteidx == -1) {
		return NULL;
	} else {
		return (notename[noteidx]);
	}
}

int saftNote::getNoteIdx() {
	return (noteidx);
}

int saftNote::getOctave() {
	return (octave);
}

float saftNote::getFrequency() {
	return (freq);
}

/* 
	calcutes the note and its octave from the frequency
	the tolerance is a half-tone (s_2_48)
*/
int saftNote::calc() {
	int i = 0, maxi = 0;
	float f = freq;

	const float s_2_48 = 1.014545;
	while (f < (notevalue[0]/s_2_48)) {
		f = f * 2;
		i--;
	}
	while (f > (notevalue[11]*s_2_48)) {
		f = f / 2;
		i++;
	}
	while (notevalue[maxi]*s_2_48 < f) {
		maxi++;
	}
/* f is below note+(1/4 tone) */
 
	if (notevalue[maxi]/s_2_48 < f) {
		noteidx	= maxi;
		octave	= i;
	}
	return (0);
}

