#include <rfftw.h>
#include <math.h>

#include "soundfft.h"

rfftw_plan p;
float *f_data=NULL;
float *U_data=NULL;

saftFFT::saftFFT (saftSound *saft, int plen ) {
	sound = saft;
	
	f_data = (float *)calloc(sound->getLength(), sizeof(float));
	U_data = (float *)calloc(sound->getLength(), sizeof(float));
	
	p = rfftw_create_plan(sound->getLength(), FFTW_REAL_TO_COMPLEX, FFTW_ESTIMATE);
	
	if (plen > 0 ) {
		if (power_length > sound->getLength()) {
			power_length = sound->getLength();
		} else {
			power_length = plen;
		}
		maxp = (int *)malloc(plen * sizeof(int));
	} else {
		power_length = 0;
	}
	
	
}

saftFFT::~saftFFT () {
	rfftw_destroy_plan(p);
	
	free(f_data);
	free(U_data);
}
/*
	1. Calculates the frequence-spectrum of the sampled data
	2. Calculates the (n). highest amplitudes
*/
void saftFFT::calc () {
	fftw_real temp, *in2, *out, *power_spectrum;
	int j, i, my = 0, peak = -1;
	long k;
/* freq-spec */
	int N2 = sound->getLength() * sound->getLength();
	float freq_corr = sound->getSpeed()/(float)sound->getLength();
	
	in2 = (fftw_real *)malloc(sound->getLength() * sizeof(fftw_real));
	out = (fftw_real *)malloc(sound->getLength() * sizeof(fftw_real));
	power_spectrum = (fftw_real  *)malloc(sound->getLength() * sizeof(fftw_real));
	
	for(i = 0; i < sound->getLength(); i++)  {
		in2[i]=((float)sound->getData(i))*(.54 - .46 * cos(2.0 * M_PI * (float)i/(sound->getLength()-1)));
	}
	
	rfftw_one(p, in2, out);
	
	power_spectrum[0] = out[0]*out[0];  /* DC component */
	for (k = 1; k < (sound->getLength()+1)/2; ++k)  /* (k < N/2 rounded up) */
		power_spectrum[k] = out[k]*out[k] + out[sound->getLength()-k]*out[sound->getLength()-k];
	if (sound->getLength() % 2 == 0) /* N is even */
		power_spectrum[sound->getLength()/2] = out[sound->getLength()/2]*out[sound->getLength()/2];  /* Nyquist freq. */


	for (i = 1; i < sound->getLength(); i++ ) {
		temp = power_spectrum[i];
		f_data[i] = i * freq_corr; 
		U_data[i] = temp / N2; 
	}
	
	free(in2);
	free(out);
	free(power_spectrum);
	
/* max-amplitude */
	if (power_length > 0) {
		i = 0;
		while (i < power_length) {maxp[i++] = 0;}
/* the first five (j=5) elements are skiped. they are the DC-part of 
   our spectrum. the number 5 is NOT calculated, but works for my purposes.
   This can be changed into:
   	skip everything below 10Hz. ->  (10/freq_corr)
*/
		for (j=5; j < sound->getLength()-1; j++) {

			if (peak == -1 && U_data[j] < U_data[j+1]) {
				peak = 0;
			} else if (peak == 0 && U_data[j] > U_data[j+1]) {
				peak = 1;
			} else if ( (peak == 1) && ((my < power_length) || (U_data[j] > U_data[maxp[power_length-1]]))) {
	/* peak is detected. now find a fitting place in our MAX-Power-array */
				int mo,mi;

				for (mi = 0;mi<my;mi++) {
					if (U_data[j] > U_data[maxp[mi]]) break;
				}
				
				for (mo = power_length-1;mo>mi;mo--) {
					maxp[mo] = maxp[mo-1];
				}
				maxp[mi] = j;
				if (my < power_length) my++;
				peak = -1;
			}
		}
	}
}

float saftFFT::getFrequency (int idx) {
	if (idx < 0 || idx > sound->getLength()) {
		return ( -1 );
	} else {
		return (f_data[idx]);
	}
}

float saftFFT::getAmplitude (int idx) {
	if (idx < 0 || idx > sound->getLength()) {
		return ( -1 );
	} else {
		return (U_data[idx]);
	}
}

int saftFFT::getMaxAmplitudeIdx (int idx) {
	if (idx < 0 || idx > power_length) {
		return ( -1 );
	} else {
		return (maxp[idx]);
	}
}

int saftFFT::getMaxAmplitudeLength () {
	return (power_length);
}
