/* Chord/Note detection
 * Copyright (C) 1999 Jan Kneschke
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * You should have received a copy of the GNU General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <string.h>

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>

#include <vector>
#include "soundnote.h"
#include "soundchord.h"

const char *chordtable[] = {
	"+4+3",		"",
	"+3+4",		"m",
	"+4+3+3",	"7",
	"+4+3+4",	"j7",
	"+3+4+3",	"m7",
	"+3+4+4",	"mj7",
	""
};

char rstr[] = "        ";



saftChord::saftChord (saftFFT *myfft, int maxnotes) {
	fft = myfft;
}

saftChord::~saftChord () {
}

char *saftChord::createChord(vector<saftNote*> &sorted) {
	int i,j,k = -1;
	saftNote *note;
	
	int last_note = -1;
	
/* sort the notes according to the index we get via saftNote::getNoteIdx() */
	for (i = 0; i < fft->getMaxAmplitudeLength(); i++) {
		int taggedj = -1;
		int higher_border = 12;
		
		for (j = 0; j < fft->getMaxAmplitudeLength(); j++) {
			note = new saftNote(fft->getFrequency(fft->getMaxAmplitudeIdx(j)));
			if (note->getNoteIdx() > -1) {
//				cout << "J: " << j << " -> " << note->getNoteIdx() << "\n";
				
				if ((note->getNoteIdx() < higher_border && note->getNoteIdx() > last_note)) {
//					cout << "new MIN is " << note->getNoteIdx();
					higher_border = note->getNoteIdx();
					taggedj = j;
				}
//				cout << "\n";
			}
			delete note;
		}
		last_note = higher_border;
		
		if (taggedj != -1) {
//			cout << "Got new value\n";
			note = new saftNote(fft->getFrequency(fft->getMaxAmplitudeIdx(taggedj)));
			if (note->getNoteIdx() > -1) {
				sorted.push_back(note);
			}
//			cout << "i: " << i << " | u-gr: " << higher_border << " | pos: " << taggedj << " | n-name: " << note->getNote() <<"\n";
		} else {
//			cout << "No new value\n";
		}


		
/* FIXME: i don't know if this push_back copys the object. perhaps we have to:
		delete note;
*/
	}
	for (i = 0; i < sorted.size(); i++) {
		cout << i << ": " << sorted[i]->getNote() << " ";
	}
	cout << "\n";

}

const char *saftChord::getChord () {
	int j = 0, chord_found = 0,i,l;
	char fl[3],rest[128];	// first letter
	int last = 0;
	vector<saftNote*> sorted_notes;
	
	createChord(sorted_notes);
	
	for (l = 0;l < sorted_notes.size();l++ ) {
		last = -1;
		rest[0] = '\0';
		for ( j = 0; j < sorted_notes.size(); j++ ) {
			int idx;
			if (j+l >=  sorted_notes.size()) {
				idx = j+l - sorted_notes.size();
			} else {
				idx = j+l;
			}
			if (last != -1) {
				if (sorted_notes[idx]->getNoteIdx()-last > 0) {
					sprintf(rest,"%s+%i",rest,sorted_notes[idx]->getNoteIdx()-last);
				} else {
					sprintf(rest,"%s+%i",rest,sorted_notes[idx]->getNoteIdx()-last+12);
				}
			} else {
				sprintf(fl, "%s",sorted_notes[idx]->getNote());
			}
			last = sorted_notes[idx]->getNoteIdx();
		}
		
		if (strlen(rest) > 0) {
			i = 0;
			while (strlen(chordtable[i*2]) > 0) {
				if (strcmp(rest, chordtable[i*2]) == 0) {
					chord_found = 1;
					break;
				}
				i++;
			}
			if (chord_found) {
				sprintf(rstr, "%s%s\n",fl,chordtable[i*2+1]);
				return(rstr);
				break;
			} else {
//				printf("-------> %s%s\n",fl,rest);
			}
		} else {
//			printf("Note  -> %s\n",fl);
			break;
		}
	}
	return NULL;
}
