
#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <unistd.h>

#include <sys/ioctl.h>
#include <sys/soundcard.h>

#include <g++/iostream.h>

#include "soundbase.h"

saftSound::saftSound () {
	channels = 0;		// 0 = mono, 1=stereo
	
				// 8 bit	| 16 bit
	format = AFMT_S16_LE;	// AFMT_U8	| AFMT_S16_LE
	speed = 44100;
	length = 16384;		// 16384
	wordsize = 2;		// 1		| 2
	
	if (init ()) {
		fd = -1;
	}
}
int saftSound::init () {
	// sound einschalten
	if ((fd = open("/dev/dsp",O_RDONLY | O_NONBLOCK)) < 0) {
		cerr << "Can't open /dev/dsp\n";
		return(-1);
	}
	
	if (setParameters()) {
		cerr << "Can't set DSP parameters\n";
		return(-1);
	}
	
	in = (char *)calloc (length , wordsize);
	in_ss = (signed short *)in;
// tempprary buffer for get_data
	in2 = (char *)malloc (length * wordsize);

/* sound-buffer is currently empty */
	filling = 0;
	
	return 0;
}

saftSound::~saftSound() {
	if (fd != -1) {
		free(in);
		free(in2);
		close (fd);
	}
}

void saftSound::sampleData()
{
	int i = 0;
	
	if (fd == -1) {
		cerr << "no filehandle for sound\n";
		return;
	}
	
	if (filling < (length*wordsize)) {
/* the sound-buffer isn't filled up. do it now. */
		while (filling < (length*wordsize)) {
			i = read(fd, in2, (length * wordsize) - filling);
			if ( i > 0 ) {
				memcpy( in + filling, in2, i);
				filling += i;
			} else if (i == -1) {
				cerr << "pre: Read Error\n";
			} else {
//				cerr << "pre: Read Nothing\n";
			}
		}
	} else {
		i = read(fd, in2, length * wordsize);
		if ( i > 0 ) {
			memcpy( in, in + i, (length * wordsize) - i);
			memcpy( in + (length * wordsize) - i, in2, i);
		} else if (i == -1) {
			cerr << "Read Error\n";
		} else {
//			cerr << "Read Nothing\n";
		}
	}
}

signed short saftSound::getData(int idx) {
	return (wordsize == 1 ? (signed char)(in[idx]-128) : in_ss[idx]);
}

int saftSound::setParameters(void)
{
	if (fd == -1) {
		cerr << "no filehandle for sound\n";
		return(-1);
	}
	if (ioctl(fd, SNDCTL_DSP_CHANNELS, &(channels)) == -1) {
		cerr << "bad channels setting.";
		return(-1); 
	} 

	if (ioctl(fd, SNDCTL_DSP_SETFMT, &(format))==-1) {
		cerr << "bad sound format.";
		return(-1); 
	} 

	if (ioctl(fd, SNDCTL_DSP_SPEED, &(speed)) == -1) {
		cerr << "bad sampling rate.";
		return(-1); 
	}
	return(0);
}

int saftSound::getLength() {
	return(length);
}

int saftSound::getSpeed() {
	return(speed);
}