/* SAFT - sample demostration
 * Copyright (C) 1999 Jan Kneschke
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * You should have received a copy of the GNU General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <g++/iostream.h>

#include "soundbase.h"
#include "soundfft.h"
#include "soundnote.h"
#include "soundchord.h"


int main(int argc, char *argv[]) {
	saftSound *sound = new saftSound();
	saftFFT *fft = new saftFFT (sound);
	
	int i;
	cout << "-- Sampling Data --" << "\n";
#if 0	
	for (i = 0;i < 10 ;i++) {
		sound->sampleData();
		fft->calc();
		cout << i << ". Byte: " << sound->getData(0)    << "\t";
		cout << i << ". Freq: " << fft->getFrequency(5) << "\t";
		cout << i << ". Ampl: " << fft->getAmplitude(5) << "\n";
	}

	cout << "-- Calculating Notes --" << "\n";
	
	for (i = 0;i < 100 ;i++) {
		saftNote *note = new saftNote(260.0+(2.6 * i));
		cout << i << ". Frequency: " << note->getFrequency() << "\t";
		cout << i << ". Note: " << note->getNote() << "\t";
		cout << i << ". Octave: " << note->getOctave() << "\n";
		delete note;
	}
#endif
	cout << "-- Detection of Chords --" << "\n";
	
	sound->sampleData();
	fft->calc();
	
	for (i = 0;i < fft->getMaxAmplitudeLength() ;i++) {
		saftNote *note = new saftNote(fft->getFrequency(fft->getMaxAmplitudeIdx(i)));
		cout << i << ". Freq: " << note->getFrequency() << "\t";
		cout << " Note: " << note->getNote() << " ("<< note->getNoteIdx() <<")\t";
		cout << " Octv: " << note->getOctave() << "\t";
		cout << " Ampl: " << fft->getAmplitude(fft->getMaxAmplitudeIdx(i)) << "\n";
		delete note;
	}
	
	saftChord *chord = new saftChord(fft);
	for (i = 0;i < 10 ;i++) {
		chord->getChord();
		sound->sampleData();
		fft->calc();
	}
	delete chord;
	
	delete fft;
	
	delete sound;
	
	return 0;
}
