#include <kapp.h>
#include <qpushbutton.h>
#include <qtimer.h>

#include "ksaft.h"

#include "soundnote.h"
#include "soundchord.h"


KSaft::KSaft () {
	l = new QPushButton(this);
	l->setText("");
	
	sound = new saftSound();
	fft = new saftFFT (sound);
	
	t = new QTimer();
	connect(t, SIGNAL(timeout()), SLOT(slotUpdate()));
	connect(l, SIGNAL(clicked()), kapp, SLOT(quit()));
	t->start(0, FALSE);
}

KSaft::~KSaft() {
	t->stop();
	delete fft;
	delete sound;
	delete t;
	delete l;
}

KSaft::slotUpdate() {
	QString b;
	saftChord *chord = new saftChord(fft);
	
	sound->sampleData();
	fft->calc();
	
	b = chord->getChord();

	if (b.isNull() == FALSE) {
		l->setText(b);
	}
	delete chord;
}


int main (int argc, char *argv[]) {
	KApplication a(argc,argv);
	
	KSaft* ksaft = new KSaft();
	ksaft->show();
	
	a.exec();

}
