#include <errno.h>
#include <stdio.h>
#include <string.h>
#include <time.h>
#include <sys/time.h>
#include <sys/types.h>
#include <unistd.h>
#include <stdlib.h>
#include <signal.h>
#include <ncurses.h>

#include "soundbase.h"
#include "soundfft.h"

#define CURSOR_INVISIBLE      0   
#define CURSOR_NORMAL         1
#define CURSOR_BOLD           2

#define WHITE_ON_BLUE         1
#define YELLOW_ON_BLUE        2
#define RED_ON_BLUE           3
#define GREEN_ON_BLUE         4
#define WHITE_ON_BLACK        5

static int  enable_quit = 1;
static int  stat_x;
static int  stat_y;
static int  color;
time_t current_time;

saftSound *sound ;
saftFFT *fft;

int ffr = 0;
struct timeval tv = {0,0}, tp, tc;

void cleanup(int dummy) {
  /*
   * okay, all done. clear the screen and quit ncurses
   */
  clear();
  if (color == TRUE) {
    attron(COLOR_PAIR(WHITE_ON_BLACK));
    attroff(A_BOLD);
  }
  endwin();
  exit(0);
}

/*
 * init ncurses and check if colors can be used.
 */
int init_ncurses() {
  initscr();
  noecho();
  nonl();
  refresh();
  cbreak();
  nodelay(stdscr,TRUE);
  keypad(stdscr,TRUE);
  curs_set(CURSOR_INVISIBLE);
  return(TRUE);
}

int draw_status () {
	int i,j;
	char s[256];
	
	sound->sampleData();
	fft->calc();
	
	for (i = 0;i < LINES-10 ;i++) {
		for (j=0;j < COLS-6;j++) {
			if (fft->getAmplitude(sound->getLength()/2/(COLS-5)*j) > 100*i) {
				mvaddch(LINES-6-i,j+3,'#');
			} else {
				mvaddch(LINES-6-i,j+3,' ');
			}
		}
	}
	
	
	ffr++;
	if (ffr == 10) {
		gettimeofday(&tc, NULL);
		sprintf (s,"%3.2f updates/s",ffr*1000/(float)((tc.tv_sec  - tp.tv_sec)  * 1000 + (tc.tv_usec - tp.tv_usec) / 1000));
		mvaddstr(LINES-5,35,s);
		gettimeofday(&tp, NULL);
		ffr = 0;
	}
	return(0);
}

int draw_mask(int color) {
  int  line;
  int  col;
  
  if (color == TRUE) {
    attron(A_BOLD);
    attron(COLOR_PAIR(WHITE_ON_BLUE));
  }
  move(0, 0);
  addch(ACS_ULCORNER);
  for(col=2; col<COLS; col++)
    addch(ACS_HLINE);
  addch(ACS_URCORNER);
  for (line=1; line<LINES-4; line++) {
    move(line, 0);
    addch(ACS_VLINE);
    for(col=2; col<COLS; col++)
      addch(32);
    addch(ACS_VLINE);
  }
  move(LINES-4, 0);
  addch(ACS_LLCORNER);
  for(col=2; col<COLS; col++)
    addch(ACS_HLINE);
  addch(ACS_LRCORNER);
  if (color == TRUE) {
    attroff(COLOR_PAIR(WHITE_ON_BLUE));
    attron(COLOR_PAIR(WHITE_ON_BLACK));
  }
  if (enable_quit) {
    move(LINES-2, 1);
    addstr("Press Ctrl+C to quit");
  }
  mvaddstr(1, 2, "cSAFT 0.2");
  mvaddstr(1, COLS-36 , "Compilation-Date: ");
  mvaddstr(1, COLS-17 , __DATE__);
  
  return(TRUE);
}

int main(int argc, char **argv) {
  int   quit;
  sound = new saftSound();
  fft = new saftFFT (sound);
  
  init_ncurses();
  draw_mask(color);
  stat_x = 0;
  stat_y = 0;
  refresh();
  quit = 0;

  /*
   * Install Signal-Handlers
   */
  signal(SIGTERM,cleanup);
  if (enable_quit) {
    signal(SIGHUP,cleanup);
    signal(SIGINT,cleanup);
  } else {
    sigblock(SIGHUP);
    sigblock(SIGINT);
  }
  /*
   * loop until the user pressed  "Ctrl+C"
   */
   gettimeofday(&tp, NULL);
  do {
    draw_status();
    refresh();
  } while (!quit);
  cleanup(0);
  	delete fft;
	
	delete sound;
  return 0;
}
