/* Emacs style mode select   -*- C -*- 
//-----------------------------------------------------------------------------
//
// $Id: i_video.h,v 1.4 1998/08/31 22:11:32 chris Exp $
//
// Copyright (C) 1993-1996 by id Software, Inc.
//
// This source is available for distribution and/or modification
// only under the terms of the DOOM Source Code License as
// published by id Software. All rights reserved.
//
// The source is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// FITNESS FOR A PARTICULAR PURPOSE. See the DOOM Source Code License
// for more details.
//
// $Log: i_video.h,v $
// Revision 1.4  1998/08/31 22:11:32  chris
// added InitGraphLib() prototype
//
// Revision 1.3  1998/08/31 16:06:45  chris
// removed I_ReadScreen() prototype (now in v_video.h)
//
// Revision 1.2  1998/04/24 21:50:40  chris
// added forgotten ';' after I_Checkres()
//
// Revision 1.1  1998/04/23 22:49:51  chris
// Initial revision
//
//
// DESCRIPTION:
//	System specific interface stuff.
//
//---------------------------------------------------------------------------*/


#ifndef __I_VIDEO__
#define __I_VIDEO__


#include "doomtype.h"

#ifdef __GNUG__
#pragma interface
#endif


/* Called by D_DoomMain,
 * determines the hardware configuration
 * and sets up the video mode
 */
void I_InitGraphics (void);
void InitGraphLib(void);  /* called right at the beginning to give up root */
                          /* rights as soon as possible                    */

void I_ShutdownGraphics(void);

/* Takes full 8 bit values. */
void I_SetPalette (byte* palette);

void I_UpdateNoBlit (void);
void I_FinishUpdate (void);

/* Wait for vertical retrace or pause a bit. */
void I_WaitVBL(int count);

void I_BeginRead (void);
void I_EndRead (void);

void I_CheckRes();

#endif

/*
 * Local variables:
 * c-basic-offset: 4
 * c-file-style: "cpg"
 * End:
 */
