/* Emacs style mode select   -*- C -*-
//-----------------------------------------------------------------------------
//
// $Id: i_system.c,v 1.7 1998/10/18 02:06:12 chris Exp $
//
// Copyright (C) 1993-1996 by id Software, Inc.
//
// This source is available for distribution and/or modification
// only under the terms of the DOOM Source Code License as
// published by id Software. All rights reserved.
//
// The source is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// FITNESS FOR A PARTICULAR PURPOSE. See the DOOM Source Code License
// for more details.
//
// $Log: i_system.c,v $
// Revision 1.7  1998/10/18 02:06:12  chris
// replace "ifdef SUN" with "ifdef sun" -- sun is predefined in lower
// case
//
// Revision 1.6  1998/08/20 00:46:12  chris
// removed C++ comments
//
// Revision 1.5  1998/08/20 00:42:50  chris
// I_Init(): added switches "-nosound" and "-nomusic" to turn off music
// and sound, resp.
//
// Revision 1.4  1998/06/08 23:14:36  chris
// fix in I_AllocLow(): only clear mem if malloc() returned success
//
// Revision 1.3  1998/04/22 21:08:33  chris
// set default memory allocation to 8MB -- now are multiple resolutions
// supported which need more mem
//
// Revision 1.2  1998/03/04 23:26:47  chris
// Call I_ShutdownSound() and I_ShutdownMusic()
// in I_Error().
//
// Revision 1.1  1998/02/28 02:02:24  chris
// Initial revision
//
//
// DESCRIPTION:
//
//---------------------------------------------------------------------------*/

static const char
rcsid[] = "$Id: i_system.c,v 1.7 1998/10/18 02:06:12 chris Exp $";


#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include <stdarg.h>
#include <sys/time.h>
#include <unistd.h>

#include "doomdef.h"
#include "m_misc.h"
#include "i_video.h"
#include "i_sound.h"

#include "d_net.h"
#include "g_game.h"
#include "m_argv.h"

#ifdef __GNUG__
#pragma implementation "i_system.h"
#endif
#include "i_system.h"



int	mb_used = 8;


void I_Tactile(int on,int off,int total)
{
    /* UNUSED. */
    on = off = total = 0;
}

ticcmd_t	emptycmd;
ticcmd_t*	I_BaseTiccmd(void)
{
    return &emptycmd;
}


int  I_GetHeapSize (void)
{
    return mb_used*1024*1024;
}

byte* I_ZoneBase (int*	size)
{
    *size = mb_used*1024*1024;
    return (byte *) malloc (*size);
}


/*
 * I_GetTime
 * returns time in 1/70th second tics
 */
int  I_GetTime (void)
{
    struct timeval	tp;
    struct timezone	tzp;
    int			newtics;
    static int		basetime=0;

    gettimeofday(&tp, &tzp);
    if (!basetime)
	basetime = tp.tv_sec;
    newtics = (tp.tv_sec-basetime)*TICRATE + tp.tv_usec*TICRATE/1000000;
    return newtics;
}


/*
 * I_Init
 */
void I_Init (void)
{
    if (! M_CheckParm("-nosound"))
        I_InitSound();
    else
        fprintf(stderr,"I_Init: sound disabled (-nosound)\n");
    if (! M_CheckParm("-nomusic"))
        I_InitMusic();
    else
        fprintf(stderr,"I_Init: backgound music disabled (-nomusic)\n");
}


/*
 * I_Quit
 */
void I_Quit (void)
{
    D_QuitNetGame ();
    I_ShutdownSound();
    I_ShutdownMusic();
    M_SaveDefaults ();
    I_ShutdownGraphics();
    exit(0);
}

void I_WaitVBL(int count)
{
#ifdef SGI
    sginap(1);
#else
#ifdef sun
    sleep(0);
#else
    usleep (count * (1000000/70) );
#endif
#endif
}

void I_BeginRead(void)
{
}

void I_EndRead(void)
{
}

byte* I_AllocLow(int length)
{
    byte* mem;

    mem = (byte *)malloc (length);
    if (mem) memset (mem,0,length);
    return mem;
}


/*
 * I_Error
 */
extern boolean demorecording;

#define _ERROR_HDR "Error: "

void I_Error (char *error, ...)
{
    va_list	argptr;
    char        err_buff[1024];

    /* put message first into buffer */
    va_start (argptr,error);
    strcpy(err_buff,_ERROR_HDR);
    vsprintf(err_buff+strlen(_ERROR_HDR),error,argptr);
    strcat(err_buff,"\n");
    va_end (argptr);

    /* Shutdown. Here might be other errors. */
    if (demorecording)
	G_CheckDemoStatus();

    D_QuitNetGame ();
    I_ShutdownSound();
    I_ShutdownMusic();
    I_ShutdownGraphics();

    /* now print the error to stderr */
    fprintf(stderr,"%s",err_buff);
    fflush( stderr );

    exit(-1);
}

/*
 * Local variables:
 * c-basic-offset: 4
 * c-file-style: "cpg"
 * compile-command: "make x11"
 * End:
 */
