// Emacs style mode select   -*- C -*- 
//-----------------------------------------------------------------------------
//
// $Id: i_net.c,v 1.3 1998/06/17 21:36:46 chris Exp $
//
// Copyright (C) 1993-1996 by id Software, Inc.
// IPX changes (C) 1998 by Christian Groessler (cpg@aladdin.de)
//
// This source is available for distribution and/or modification
// only under the terms of the DOOM Source Code License as
// published by id Software. All rights reserved.
//
// The source is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// FITNESS FOR A PARTICULAR PURPOSE. See the DOOM Source Code License
// for more details.
//
// $Log: i_net.c,v $
// Revision 1.3  1998/06/17 21:36:46  chris
// removed warning with typecast (netget = IPXPacketGet)
//
// Revision 1.2  1998/03/04 23:18:30  chris
// fix in I_InitNetwork()/UDP part: forgot a return
//
// Revision 1.1  1998/02/28 01:57:07  chris
// Initial revision
//
//
// DESCRIPTION:
//     Network interface
//
//-----------------------------------------------------------------------------

static const char
rcsid[] = "$Id";

#include <stdlib.h>

#include "i_system.h"
#include "m_argv.h"

#include "doomstat.h"

#ifdef __GNUG__
#pragma implementation "i_net.h"
#endif

#include "i_net.h"

#ifdef IPX_PROTOCOL
#include "i_ipx.h"
#endif
#ifdef UDP_PROTOCOL
#include "i_udp.h"
#endif

void (* netget)(void);
void (* netsend)(void);

//
// I_InitNetwork
//
void I_InitNetwork (void)
{
    int i;

    doomcom = malloc (sizeof (*doomcom) );
    memset (doomcom, 0, sizeof(*doomcom) );
    netbuffer = &doomcom->data;

// shared parameters (IPX/UDP)
    // set up for network
    i = M_CheckParm ("-dup");
    if (i && i< myargc-1)
    {
	doomcom->ticdup = myargv[i+1][0]-'0';
	if (doomcom->ticdup < 1)
	    doomcom->ticdup = 1;
	if (doomcom->ticdup > 9)
	    doomcom->ticdup = 9;
    }
    else
	doomcom-> ticdup = 1;
	
    if (M_CheckParm ("-extratic"))
	doomcom-> extratics = 1;
    else
	doomcom-> extratics = 0;
//shared parameters end

#ifdef IPX_PROTOCOL

    /* check, whether IPX network play is wanted */

    i = M_CheckParm("-ipx");
    if (i)
    {
	netsend = IPXPacketSend;
	netget = (void (*)(void)) IPXPacketGet; /* IPXPacketGet() normally returns an int */
	netgame = true;
	I_InitIPX();
	return;
    }

#endif

#ifdef UDP_PROTOCOL

    // parse UDP/IP network game options,
    //  -net <consoleplayer> <host> <host> ...
    i = M_CheckParm ("-net");
    if (i)
    {
	netsend = UDPPacketSend;
	netget = UDPPacketGet;
	netgame = true;
	I_InitUDP();
        return;
    }
#endif

    // single player game
    netgame = false;
    doomcom->id = DOOMCOM_ID;
    doomcom->numplayers = doomcom->numnodes = 1;
    doomcom->deathmatch = false;
    doomcom->consoleplayer = 0;

    // this was needed, additionally (from old I_InitNetwork())
    //doomcom->ticdup=1;
    //doomcom->extratics=0;
    return;
}


void I_NetCmd (void)
{
    if (doomcom->command == CMD_SEND)
    {
	netsend ();
    }
    else if (doomcom->command == CMD_GET)
    {
	netget ();
    }
    else
	I_Error ("Bad net cmd: %i\n",doomcom->command);
}

/*
 * Local variables:
 * c-file-style: "cpg"
 * End:
 */
