//-----------------------------------------------------------------------------
//
// $Id: fpfunc.S,v 1.3 1998/05/06 21:57:00 chris Exp $
//
// Copyright (C) 1993-1996 by id Software, Inc.
//
// This source is available for distribution and/or modification
// only under the terms of the DOOM Source Code License as
// published by id Software. All rights reserved.
//
// The source is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// FITNESS FOR A PARTICULAR PURPOSE. See the DOOM Source Code License
// for more details.
//
// DESCRIPTION:
//   This is the M68k/i386 assembly module that has been
//    used in one of the linuxdoom releases by id.
//	 It contains assembly for the following C functions:
//	  FixedMul
//    FixedDiv2
//    R_DrawColumn
//    R_DrawSpan
//
// If you are going to use this, add the -DUSEASM switch to
// the CFLAGS in the Makefile.
//
// $Log: fpfunc.S,v $
// Revision 1.3  1998/05/06 21:57:00  chris
// some comment changes by Jan Rafaj
//
// Revision 1.2  1998/04/22 21:48:33  chris
// replaced SCREENWIDTH fixed define with _screenwidth variable
// in x86 version. added AOUT_ASM ifdef. cleaned up a little bit
// (indentation etc.)
//
//
//-----------------------------------------------------------------------------




#ifdef USEASM

// -----------------------------------------------------
// Global defines
#ifdef m68k
#define	SCREENWIDTH	320
#endif

#ifndef AOUT_ASM   // global names in aout objs contain a leading underscore,
		   // ELF names do not. define AOUT_ASM if you want to compile
		   // an aout version
// This fixes linker errors. At one point in history,
//  the underscore was necessary, I will keep it for now.
#define _columnofs		columnofs
#define _ylookup		ylookup
#define _centery		centery

#define _screenwidth		screenwidth

#define _dc_x			dc_x
#define _dc_yl			dc_yl
#define _dc_yh			dc_yh
#define _dc_iscale		dc_iscale
#define _dc_texturemid  	dc_texturemid
#define _dc_source		dc_source
#define _dc_colormap		dc_colormap

#define _ds_y			ds_y
#define _ds_x1			ds_x1
#define _ds_x2			ds_x2
#define _ds_xfrac		ds_xfrac
#define _ds_yfrac		ds_yfrac
#define _ds_xstep		ds_xstep
#define _ds_ystep		ds_ystep
#define _ds_colormap		ds_colormap
#define _ds_source		ds_source


// The same problem occurs for function calls.
#define _FixedMul		FixedMul
#define _FixedDiv2		FixedDiv2
#define _R_DrawColumn		R_DrawColumn
#define _R_DrawSpan		R_DrawSpan

#endif /* ifndef AOUT_ASM */

// -----------------------------------------------------
// M68k assembly
//
#ifdef m68k

.text
	.align 1
.globl _FixedMul
_FixedMul:
	link	a6,#0
	movel	a6@(8),d0
	mulsl	a6@(12),d1:d0
	movew	d1,d0
	swap	d0
	unlk	a6
	rts

	.align 1
.globl _FixedDiv2
_FixedDiv2:
	link	a6,#0
	movel	a6@(8),d0
	swap	d0
	movw	d0,d1
	extl	d1
	movw	#0,d0
	divsl	a6@(12),d1:d0
	unlk	a6
	rts

/*
===================
=
= R_DrawColumn
=
===================
*/
	.align 1
.globl _R_DrawColumn
_R_DrawColumn:
	moveml	d2/d3/d4/d5/d6/d7/a2,sp@-

	movel	_dc_yh,d3
	movel	_dc_yl,d2
	subl 	d2,d3
	bmi 	L1				// if count < 0, do nothing

	lea	_columnofs,a1
	movel	_dc_x,d1
	movel	a1@(d1:l:4),a1
	lea 	_ylookup,a0
	addl	a0@(d2:l:4),a1

	movel	_dc_iscale,d4
	subl	_centery,d2
	mulsl	d4,d2
	addl	_dc_texturemid,d2

// d0	scratch offset / pixel 1
// d1	qaud count
// d2	frac 1
// d3	count
// d4	fracstep
// d5	SCREENWIDTH
// d6	frac 2
// d7	scratch 2

// a0	source
// a1	dest
// a2	colormap
	movel	_dc_source,a0
	movel	_dc_colormap,a2

	addql	#1,d3
	movel	d3,d1
	lsrl	#2,d1
	beq	Lcsinglestart
	subql	#1,d1
	bfextu 	d2{#9:#7},d0	// feed the first step of the pipeline
	movel	d2,d6
	addl	d4,d6			// put d6 a step ahead of d2
	lsll	#1,d4			// make the step a double step
	movel	#SCREENWIDTH*4,d5
	jmp	Lcquadloop

	.align 4
Lcquadloop:
	bfextu	d6{#9:#7},d7
	moveb	a0@(d0),d0
	addl	d4,d2
	moveb	a0@(d7),d7
	addl	d4,d6
	moveb	a2@(d0),a1@
	bfextu	d2{#9:#7},d0
	moveb	a2@(d7),a1@(SCREENWIDTH)

	bfextu	d6{#9:#7},d7
	moveb	a0@(d0),d0
	addl	d4,d2
	moveb	a0@(d7),d7
	addl	d4,d6
	moveb	a2@(d0),a1@(SCREENWIDTH*2)
	bfextu	d2{#9:#7},d0
	moveb	a2@(d7),a1@(SCREENWIDTH*3)

	addl	d5,a1
	dbra	d1,Lcquadloop

	lsrl	#1,d4			// put the step value back to singles

Lcsinglestart:
	andil	#3,d3
	beq	L1			// no extras
	movel	#SCREENWIDTH,d5
	subql	#1,d3

Lcsingleloop:
	bfextu	d2{#9:#7},d0
	moveb	a0@(d0),d0
	addl	d4,d2
	moveb	a2@(d0),a1@

	addl	d5,a1
	dbra	d3,Lcsingleloop

L1:
	moveml	sp@+,d2/d3/d4/d5/d6/d7/a2
	rts

/*
===================
=
= R_DrawSpan
=
===================
*/

	.align 1
.globl _R_DrawSpan
_R_DrawSpan:
	moveml d2/d3/d4/d5/d6/d7/a2,sp@-

	movel	_ds_x2,d7
	cmpl	_ds_x1,d7
	movel	_ds_y,d1
	lea	_ylookup,a1
	movel	_ds_x1,d0
	lea	_columnofs,a0
	movel	a1@(d1:l:4),a1
	addl	a0@(d0:l:4),a1
	movel	_ds_x2,d3
	subl	_ds_x1,d3

// d0	extracted yfrac / composite
// d1	extracted xfrac
// d2	xfrac yfrac
// d3	loop count
// d4	xstep ystep
// d5	pixel
// d6	quad count

// a0	ds_source
// a1	dest
// a2	ds_colormap

	clrl	d5
	movel	_ds_source,a0
	movel	_ds_colormap,a2

// build frac
	movel	_ds_yfrac,d2
	moveq	#10,d0
	lsll	d0,d2
	andil	#0xffff0000,d2
	movel	_ds_xfrac,d0
	lsrl	#6,d0
	andil	#0xffff,d0
	addl	d0,d2
// build step
	movel	_ds_ystep,d4
	moveq	#10,d0
	lsll	d0,d4
	andil	#0xffff0000,d4
	movel	_ds_xstep,d0
	lsrl	#6,d0
	andil	#0xffff,d0
	addl	d0,d4

	addql	#1,d3
	movel	d3,d6
	lsrl	#2,d6
	beq	Lsinglestart
	subql	#1,d6
//	lsll	#1,d4		// make the step a double step

Lquadloop:
	bfextu	d2{#0:#6},d0	// extract y
	bfextu	d2{#16:#6},d1	// extract x
	lsll	#6,d0
	addl	d1,d0
	addl	d4,d2		// advance fraction
	moveb	a0@(d0),d5	// get source pixel
	moveb	a2@(d5),a1@+	// translate and write out to dest

	bfextu	d2{#0:#6},d0	// extract y
	bfextu	d2{#16:#6},d1	// extract x
	lsll	#6,d0
	addl	d1,d0
	addl	d4,d2		// advance fraction
	moveb	a0@(d0),d5	// get source pixel
	moveb	a2@(d5),a1@+	// translate and write out to dest

	bfextu	d2{#0:#6},d0	// extract y
	bfextu	d2{#16:#6},d1	// extract x
	lsll	#6,d0
	addl	d1,d0
	addl	d4,d2		// advance fraction
	moveb	a0@(d0),d5	// get source pixel
	moveb	a2@(d5),a1@+	// translate and write out to dest

	bfextu	d2{#0:#6},d0	// extract y
	bfextu	d2{#16:#6},d1	// extract x
	lsll	#6,d0
	addl	d1,d0
	addl	d4,d2		// advance fraction
	moveb	a0@(d0),d5	// get source pixel
	moveb	a2@(d5),a1@+	// translate and write out to dest

	dbra	d6,Lquadloop

Lsinglestart:
	andil	#3,d3
	beq	Ldone		// no extras
	subql	#1,d3
Lsingleloop:
	bfextu	d2{#0:#6},d0	// extract y
	bfextu	d2{#16:#6},d1	// extract x
	lsll	#6,d0
	addl	d1,d0
	addl	d4,d2		// advance fraction
	moveb	a0@(d0),d5	// get source pixel
	moveb	a2@(d5),a1@+	// translate and write out to dest
	dbra	d3,Lsingleloop

Ldone:
	moveml	sp@+,d2/d3/d4/d5/d6/d7/a2
	rts

#endif
//
// End of M68k assembly
// -----------------------------------------------------
// PC/i386 assembly
//
#ifdef i386

.text
	.align 4
.globl _FixedMul
_FixedMul:
	pushl	 %ebp
	movl	%esp,%ebp
	movl	8(%ebp),%eax
	imull	12(%ebp)
	shrdl	$16,%edx,%eax
	popl	%ebp
	ret

	.align 4
.globl _FixedDiv2
_FixedDiv2:
	pushl	%ebp
	movl	%esp,%ebp
	movl	8(%ebp),%eax
	cdq
	shldl	$16,%eax,%edx
	sall	$16,%eax
	idivl	12(%ebp)
	popl	%ebp
	ret


/*
==================
=
= R_DrawColumn
=
eax		colormap
ebx		scratch
ecx		count
edx		frac
esi		column source
edi		dest
ebp		fracstep
==================
*/
	.align 4
.globl _R_DrawColumn
_R_DrawColumn:
	movl 	_dc_yl,%eax
	movl 	_dc_yh,%ecx
	subl 	%eax,%ecx
	incl	%ecx
	jz	L1
	js	L1			// no pixels to map

	pushl	%ebp
	pushl	%edi
	pushl	%esi
	pushl	%ebx

	movl 	_ylookup(,%eax,4),%edi
	subl	_centery,%eax		// %eax = dc_yl - centery
	movl 	_dc_x,%ebx
	addl 	_columnofs(,%ebx,4),%edi	// %edi = destination in buffer

	movl 	_dc_iscale,%ebp		// %ebp = fracstep
	imull 	%ebp
	movl	%eax,%edx		// %edx = (centery-dc_yl)*dc_iscale
	addl 	_dc_texturemid,%edx	// add texture pos at screen center
	shll	$9,%edx			// shift so units are flush with bit 31
	shll	$9,%ebp			// shift so units are flush with bit 31

	movl	_dc_source,%esi		// %esi = top of vertual column
	movl	_dc_colormap,%eax	// %eax = colormap

	.align 4,0x90
L2:
	movl	%edx,%ebx		// get the current frac position
	shrl	$25,%ebx		// shift off the fractional bits
	movb	(%esi,%ebx),%al		// get the source pixel
	movb	(%eax),%al		// color map it
	addl	%ebp,%edx		// step the fractional value
	movb	%al,(%edi)		// write it to the frame buffer
//	addl	$SCREENWIDTH,%edi	// go down to next row
	addl	_screenwidth,%edi
	decl	%ecx			// any more to do?
	jnz	L2

// done
	popl	%ebx
	popl	%esi
	popl	%edi
	popl	%ebp
L1:
	ret



/*
==================
=
= _R_DrawSpan
=
eax		colormap
ebx		scratch
ecx		frac postion
edx		frac step
esi		source
edi		dest
ebp		counter


==================
*/
	.align 4
.globl _R_DrawSpan
_R_DrawSpan:

	pushl	%ebp
	pushl	%edi
	pushl	%esi
	pushl	%ebx

// get destination
	movl	_ds_y,%edx
	movl	_ds_x1,%eax
	movl	_ylookup(,%edx,4),%edi
	addl	_columnofs(,%eax,4),%edi

// get count
	movl 	_ds_x2,%ebp
	subl 	%eax,%ebp
	incl	%ebp

// pack position into one word
	movl	_ds_xfrac,%eax
	shll	$10,%eax
	andl	$0xffff0000,%eax
	movl	_ds_yfrac,%ecx
	shrl	$6,%ecx
	andl	$0x0000ffff,%ecx
	orl	%eax,%ecx

// pack step into one word
	movl	_ds_xstep,%eax
	shll	$10,%eax
	andl	$0xffff0000,%eax
	movl	_ds_ystep,%edx
	shrl	$6,%edx
	andl	$0x0000ffff,%edx
	orl	%eax,%edx

	movl	_ds_colormap,%eax	// %eax = colormap
	movl	_ds_source,%esi		// %esi = source

	.align 4,0x90
L3:
	shldl 	$22,%ecx,%ebx		// shift y units in
	shldl 	$6,%ecx,%ebx		// shift x units in
	andl	$4095,%ebx		// mask off slop bits
	movb	(%esi,%ebx),%al		// get source pixel
	movb    (%eax),%al		// translate color
	addl	%edx,%ecx		// position += step
	stosb				// write pixel and increment
	decl	%ebp
	jnz	L3

// done
	popl	%ebx
	popl	%esi
	popl	%edi
	popl	%ebp
	ret


#endif
// -----------------------------------------------------
// End of PC/i386 assembly
//

#endif // USEASM
