#!/bin/sh 
#delta-wais by Simon Spero (ses@sunsite.unc.edu).  
#Add incrementally to a recursive Wais index.
#Usage: delta-wais <database> <top of stuff to index> <other args to waisindex>

WAISBINDIR=
PATH=$WAISBINDIR:$PATH
name=$1
shift
directory=$1
shift

find $directory -type f -print | grep -v \\.cap | grep -v \\.cache | xargs ls -l | sort >$name$$
if [ -f $name-old-list ]
then
	diff  $name-old-list  $name$$ | grep '^>' | 
	  awk '{print $9}' >$name-list
	append='-a'
else
	awk '{print $8}' $name$$ >$name-list
	append=' '
fi

count=`wc -l $name-list | awk '{print $1}'`
if [ "$count" = "0" ] 
then
	echo Nothing to do
else 
	echo Adding $count 'document(s)' to $name
	waisindex $append -nopairs -d $name -stdin $* <$name-list 
fi
mv $name$$ $name-old-list
rm $name-list 
