// Copyright (C) 2000 Dominic Letourneau (doumdi@yahoo.com)

// FuzzyFunction.cc: implementation of the FuzzyFunction class.
//
//////////////////////////////////////////////////////////////////////

#include "FuzzyFunction.h"


//////////////////////////////////////////////////////////////////////
// Construction
//////////////////////////////////////////////////////////////////////

FuzzyFunction::FuzzyFunction()
  : BufferedNode("INVALID",ParameterSet()) {

}

FuzzyFunction::FuzzyFunction(const string &name) 
  : BufferedNode("INVALID",ParameterSet()), m_name(name) {


}

FuzzyFunction::FuzzyFunction(string nodeName, ParameterSet params)
 : BufferedNode(nodeName,params) {


  m_functionID = addOutput("FUNCTION");
}
//////////////////////////////////////////////////////////////////////
// Destruction
//////////////////////////////////////////////////////////////////////
FuzzyFunction::~FuzzyFunction() {

}
//////////////////////////////////////////////////////////////////////
// returns the name of the function
//////////////////////////////////////////////////////////////////////
const string & FuzzyFunction::get_name() {
  return m_name;
}
//////////////////////////////////////////////////////////////////////
// calculate
//////////////////////////////////////////////////////////////////////
void FuzzyFunction::calculate(int output_id, int count, Buffer &out) {

  out[count] = ObjectRef(new Vector<ObjectRef>(1,clone()));

}



