// Copyright (C) 1999 Jean-Marc Valin
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this file.  If not, write to the Free Software Foundation,
// 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

#ifndef GROWING_FRAME_BUFFER_H
#define GROWING_FRAME_BUFFER_H

#include <vector>
#include "Array.h"
#include "Object.h"
#include "GrowingBuffer.h"
#include "net_types.h"

template <class T>
class GrowingFrameBuffer : public GrowingBuffer
{
public:
   GrowingFrameBuffer(int vLength, int bLength=1)
      : GrowingBuffer (bLength)
      , vectorLength(vLength)
   {
      for (int i=0;i<bLength;i++) 
         {
            data[i]= ObjectRef (new Array<T> (vLength));
            data[i]->status = Object::nil;
         }
   }

   ObjectRef & operator[] (int ind) 
   {
      if (ind > currentPos)
      {
         int oldPos = currentPos;
         currentPos = ind;
         data.resize(ind+1,ObjectRef(new Array<T> (vectorLength)));
         for (int i=oldPos+1;i<=ind;i++)
            data[ind]->status = Object::nil;
      }
      if (ind < 0)
      {
         //cerr << "ind = " << ind << endl;
         throw new GrowingBufferException (this, "trying to access non-existing element",ind);
      }
      return data[ind];
   }

    ObjectRef operator[] (int ind) const
   {
      if (ind > currentPos)
      {
         int oldPos = currentPos;
         currentPos = ind;
         data.resize(ind+1,ObjectRef(new Array<T> (vectorLength)));
         for (int i=oldPos+1;i<=ind;i++)
            data[ind]->status = Object::nil;
      }
      if (ind < 0)
      {
         throw new GrowingBufferException (this, "trying to access non-existing element",ind);
      }
      return data[ind];
      }
protected:
   int vectorLength;

};


#endif
