/*
 * Initial main.c file generated by Glade. Edit as required.
 * Glade will not overwrite this file.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <locale.h>
#include <gnome.h>


#include "UIDocument.h"
#include "GUIDocument.h"
#include "BaseException.h"
#include "path.h"
#include <signal.h>


GnomeMDI *mdi;

GtkWidget *runButton;
GtkWidget *stopButton;

gint remove_doc_cb (GnomeMDI *mdi, GnomeMDIChild *child)
{

   GnomeMessageBox *msgbox;
   int ret, *ptr;
   char *fname;
   //char *msg;
   //gE_data *data = g_malloc (sizeof(gE_data));

   //fname = (char *)doc->getName().c_str();
   //msg =   (char *)g_malloc(strlen(fname) + 52);
   //sprintf(msg, _(" '%s' has been modified. Do you wish to save it?"), fname);

   GUIDocument *doc = (GUIDocument*)gtk_object_get_data(GTK_OBJECT(child), "doc");
   string msg = " '" + doc->getName() + "' has been modified. Do you wish to save it?";

   if (mdi->active_view) {
	
      if (doc->isModified()) {
      //if (true) {
         msgbox = GNOME_MESSAGE_BOX (gnome_message_box_new (
                                                            msg.c_str(),
                                                            GNOME_MESSAGE_BOX_QUESTION,
                                                            GNOME_STOCK_BUTTON_YES,
                                                            GNOME_STOCK_BUTTON_NO,
                                                            GNOME_STOCK_BUTTON_CANCEL,
                                                            NULL));
	    							
         gnome_dialog_set_default (GNOME_DIALOG (msgbox), 2);
         ret = gnome_dialog_run_and_close (GNOME_DIALOG (msgbox));
	    	    
         switch (ret) {
	    
         case 0:
            //file_save_cb (NULL, data);
            g_print("blargh\n");
	    
         case 1:
	    delete doc;
            return TRUE;
	    
         default:
            return FALSE;
	    		
         }

      }
          
   }
	
   return TRUE;
}


static void new_doc_event  (GtkMenuItem     *menuitem,
                            gpointer         user_data)
{
   GUIDocument *doc = new GUIDocument("Untitled");
   gnome_mdi_add_child (mdi, GNOME_MDI_CHILD (doc->getMDIChild()));
   gnome_mdi_add_view  (mdi, GNOME_MDI_CHILD (doc->getMDIChild()));
}

static void file_open_ok_sel(GtkWidget *w, GUIDocument *data)
{
   GtkWidget *ssel = GTK_WIDGET(gtk_object_get_user_data(GTK_OBJECT(w)));
   gchar *fname = g_strdup(gtk_file_selection_get_filename (GTK_FILE_SELECTION(ssel)));
   //UIDocument *doc;
      
   //doc = UIDOCUMENT(mdi->active_child);
	
   if (fname) {
      //GUIDocument *doc = GUIDocument_new ();
      GUIDocument *doc = new GUIDocument("Untitled");
      gnome_mdi_add_child (mdi, GNOME_MDI_CHILD (doc->getMDIChild()));
      gnome_mdi_add_view  (mdi, GNOME_MDI_CHILD (doc->getMDIChild()));
      doc->setFullPath(fname);
      doc->load();
      doc->resetModified();
      //doc->save();
      //doc->resetModified();
      
   }
   
   g_free (fname);
   gtk_widget_destroy (GTK_WIDGET (ssel));
   ssel = NULL;
} 



static gint
file_open_destroy(GtkWidget *w, GtkWidget *sel)
{

      gtk_widget_destroy(sel);
      //*sel = NULL;
   
   return TRUE;
   
}

static void open_doc_event  (GtkMenuItem     *menuitem,
                            gpointer         user_data)
{
   GtkWidget *ssel = gtk_file_selection_new("Open file...");
   
   gtk_object_set_user_data(GTK_OBJECT(GTK_FILE_SELECTION(ssel)->ok_button),ssel);
   gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(ssel)->ok_button),
                      "clicked", (GtkSignalFunc)file_open_ok_sel, 
                      NULL);
    
   gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(ssel)->cancel_button),
                      "clicked", (GtkSignalFunc)file_open_destroy, 
                      ssel);
   
   
   gtk_widget_show(ssel);
}

static void close_doc_event  (GtkMenuItem     *menuitem,
                            gpointer         user_data)
{
   //GUIDocument *doc;
   
   if (mdi->active_child == NULL)
      return;
   
   if (gnome_mdi_remove_child (mdi, mdi->active_child, FALSE)) {
      
      if (mdi->active_child == NULL) {
         
         /*if (!settings->close_doc) {
	    
            doc = UIDocument_new ();
            gnome_mdi_add_child (mdi, GNOME_MDI_CHILD (doc));
            gnome_mdi_add_view (mdi, GNOME_MDI_CHILD (doc));
	    
         } else {
	    
            g_print ("Er.. Unimplemented alternative!\n");
	    
            }*/
         
      }
      
   }
   
}



//static GtkWidget *ssel = NULL;
static void file_saveas_ok_sel(GtkWidget *w, GUIDocument *data)
{
   GtkWidget *ssel = GTK_WIDGET(gtk_object_get_user_data(GTK_OBJECT(w)));
   gchar *fname = g_strdup(gtk_file_selection_get_filename (GTK_FILE_SELECTION(ssel)));
   
   if (mdi->active_child == NULL) {
      
      g_free (fname);
      return;
   }		  	
   
   GUIDocument *doc = (GUIDocument*)gtk_object_get_data(GTK_OBJECT(mdi->active_child), "doc");

   if (fname) {
      //cerr << "saving " << doc->getName() << " to " << (char *)fname << endl;
      doc->setFullPath(fname);
      doc->save();
      doc->resetModified();
      //if (gE_file_save(doc, fname) != 0) 
      //gnome_app_flash (mdi->active_window, _("Error saving file!"));
      
   }
   
   g_free (fname);
   gtk_widget_destroy (GTK_WIDGET (ssel));
   ssel = NULL;
} 



static gint
file_saveas_destroy(GtkWidget *w, GtkWidget *sel)
{

      gtk_widget_destroy(sel);
      //*sel = NULL;
   
   return TRUE;
   
}

static void saveas_doc_event(GtkWidget *widget, char * cbdata)
{

   gchar *title;
   //GtkWidget *ssel;

   if (mdi->active_child == NULL) {
      return;
   }
   GUIDocument *doc = (GUIDocument*)gtk_object_get_data(GTK_OBJECT(mdi->active_child), "doc");
   title = g_strdup_printf (_("Save %s As..."), (gchar*)doc->getName().c_str());
   
   GtkWidget *ssel = gtk_file_selection_new(title);
   
   gtk_object_set_user_data(GTK_OBJECT(GTK_FILE_SELECTION(ssel)->ok_button),ssel);
   gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(ssel)->ok_button),
                      "clicked", (GtkSignalFunc)file_saveas_ok_sel, 
                      NULL);
   
   gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(ssel)->cancel_button),
                      "clicked", (GtkSignalFunc)file_saveas_destroy, 
                      ssel);
   
   
   gtk_widget_show(ssel);
   
   g_free (title);


}


static void save_doc_event(GtkWidget *widget, char * cbdata)
{
   if (mdi->active_child == NULL) {
      return;
   }
   //GUIDocument *doc = GUIDOCUMENT(mdi->active_child);
   GUIDocument *doc = (GUIDocument*)gtk_object_get_data(GTK_OBJECT(mdi->active_child), "doc");

   if (doc->isUntitled())
   {
      saveas_doc_event(widget, cbdata);
      return;
   }
   if (doc->isModified())
      doc->save();
   doc->resetModified();
}

static void export_doc_event(GtkWidget *widget, char * cbdata)
{
   if (mdi->active_child == NULL) {
      return;
   }
   //GUIDocument *doc = GUIDOCUMENT(mdi->active_child);
   GUIDocument *doc = (GUIDocument*)gtk_object_get_data(GTK_OBJECT(mdi->active_child), "doc");
      
   if (doc->isUntitled())
   {
      saveas_doc_event(widget, cbdata);
      //return;
   }
   if (doc->isModified())
      doc->save();
   doc->resetModified();
   doc->export2net();
}

static void run_arg_cb(gchar * str, string *str2)
{
  *str2=str;
}

void set_run_mode (bool isRuning)
{
   GtkWidget *w = gnome_mdi_get_toolbar_info (gnome_mdi_get_active_window(mdi))[5].widget;
   gtk_widget_set_sensitive(w,!isRuning);
   w = gnome_mdi_get_toolbar_info (gnome_mdi_get_active_window(mdi))[6].widget;
   gtk_widget_set_sensitive(w,isRuning);

}

static void run_doc_event(GtkWidget *widget, char * cbdata)
{
   GUIDocument *doc = (GUIDocument*)gtk_object_get_data(GTK_OBJECT(mdi->active_child), "doc");

   set_run_mode(true);
   doc->threadRun();
}

static void doc_prop_event(GtkWidget *widget, char *cbdata) 
{
   GUIDocument *doc = (GUIDocument*)gtk_object_get_data(GTK_OBJECT(mdi->active_child), "doc");
   
   doc->showParams();
}

static void stop_doc_event(GtkWidget *widget, char *cbdata) 
{
   //cerr<<"Stopping the thread!"<<endl; 
   GUIDocument::threadStop();
}


static void exit_event  (GtkMenuItem     *menuitem,
                            gpointer         user_data)
{

   //cout<<"exiting..."<<endl;

  


   if (gnome_mdi_remove_all(mdi,FALSE))
   {
      gtk_object_destroy (GTK_OBJECT (mdi));
   } else {
      return;
   }
   
   
   gtk_main_quit();
}

static void about_event  (GtkMenuItem     *menuitem,
                            gpointer         user_data)
{
   
   const gchar *authors[] = {
      "Jean-Marc Valin (valj01@gel.usherb.ca)", "Dominic Letourneau (letd01@gel.usherb.ca)",
      NULL
   };
   GtkWidget *about;
   
   about = gnome_about_new ("vflow", VERSION,
                            _("(C) 1999-2000 Jean-Marc Valin & Dominic Letourneau"),
                            authors,
                            _("A visual data flow language. This software is part of the Open Mind Speech Recognition project (http://freespeech.on.openproject.net/)."),
                            NULL);
   gtk_object_set_data (GTK_OBJECT (about), "about", about);
   gtk_window_set_modal (GTK_WINDOW (about), TRUE);
   gtk_widget_show (about);
   //cerr << "here\n";
}



GnomeUIInfo toolbar_data[] = {

	{ GNOME_APP_UI_ITEM, N_("New"), N_("Create a new document"), (gpointer)new_doc_event,
	  NULL, NULL, GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_PIXMAP_NEW },

	{ GNOME_APP_UI_ITEM, N_("Open"), N_("Open a file"), (gpointer)open_doc_event,
	  NULL, NULL, GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_PIXMAP_OPEN },

	{ GNOME_APP_UI_ITEM, N_("Save"), N_("Save the current file"), (gpointer)save_doc_event,
	  NULL, NULL, GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_PIXMAP_SAVE },

/*	{ GNOME_APP_UI_ITEM, N_("Save As"), N_("Save the current file as..."), saveas_doc_event,
	  NULL, NULL, GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_PIXMAP_SAVE_AS },

	{ GNOME_APP_UI_ITEM, N_("Close"), N_("Close the current file"), close_doc_event,
	  NULL, NULL, GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_PIXMAP_CLOSE },
*/
        GNOMEUIINFO_SEPARATOR,

	   /*{ GNOME_APP_UI_ITEM, N_("Export"), N_("Export to a .net file"), export_doc_event,
	     NULL, NULL, GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_PIXMAP_CONVERT },*/

	{ GNOME_APP_UI_ITEM, N_("Parameters"), N_("Specify document parameters"), (gpointer)doc_prop_event,
	  NULL, NULL, GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_PIXMAP_PROPERTIES },


	{ GNOME_APP_UI_ITEM, N_("Run"), N_("Run the current document"), (gpointer)run_doc_event,
	  NULL, NULL, GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_PIXMAP_EXEC },

	{ GNOME_APP_UI_ITEM, N_("Stop"), N_("Stop the current document"), (gpointer)stop_doc_event,
	  NULL, NULL, GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_PIXMAP_STOP },


	//{ GNOME_APP_UI_ITEM, N_("Print"), N_("Print the current file"), file_print_cb,
	//  NULL, NULL, GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_PIXMAP_PRINT },

	/*GNOMEUIINFO_SEPARATOR,

	{ GNOME_APP_UI_ITEM, N_("Undo"), N_("Undo last operation"), gE_undo_do,
	  NULL, NULL, GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_PIXMAP_UNDO },
	{ GNOME_APP_UI_ITEM, N_("Redo"), N_("Redo last operation"), gE_undo_redo,
	  NULL, NULL, GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_PIXMAP_REDO },

	{ GNOME_APP_UI_ITEM, N_("Cut"), N_("Cut the selection"), edit_cut_cb,
	  NULL, NULL, GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_PIXMAP_CUT },
	{ GNOME_APP_UI_ITEM, N_("Copy"), N_("Copy the selection"), edit_copy_cb,
	  NULL, NULL, GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_PIXMAP_COPY },
	{ GNOME_APP_UI_ITEM, N_("Paste"), N_("Paste the clipboard"), edit_paste_cb,
	  NULL, NULL, GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_PIXMAP_PASTE },
	{ GNOME_APP_UI_ITEM, N_("Find"), N_("Search for a string"), search_cb,
	  NULL, NULL, GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_PIXMAP_SEARCH },
	{ GNOME_APP_UI_ITEM, N_("Line"), N_("Get the current and total lines"), count_lines_cb,
	  NULL, NULL, GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_PIXMAP_INDEX },

        */
	GNOMEUIINFO_SEPARATOR,
        
	{ GNOME_APP_UI_ITEM, N_("Exit"), N_("Exit the program"), (gpointer)exit_event,
	  NULL, NULL, GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_PIXMAP_QUIT },

	GNOMEUIINFO_END
};



static GnomeUIInfo file1_menu_uiinfo[] =
{
  GNOMEUIINFO_MENU_NEW_ITEM (N_("_New File"), NULL, new_doc_event, NULL),
  GNOMEUIINFO_MENU_OPEN_ITEM (open_doc_event, NULL),
  GNOMEUIINFO_MENU_SAVE_ITEM (save_doc_event, NULL),
  GNOMEUIINFO_MENU_SAVE_AS_ITEM (saveas_doc_event, NULL),
  GNOMEUIINFO_MENU_CLOSE_ITEM (close_doc_event, NULL),
  GNOMEUIINFO_SEPARATOR,
  GNOMEUIINFO_MENU_EXIT_ITEM (exit_event, NULL),
  GNOMEUIINFO_END
};

static GnomeUIInfo edit1_menu_uiinfo[] =
{
   /*GNOMEUIINFO_MENU_CUT_ITEM (on_cut1_activate, NULL),
  GNOMEUIINFO_MENU_COPY_ITEM (on_copy1_activate, NULL),
  GNOMEUIINFO_MENU_PASTE_ITEM (on_paste1_activate, NULL),
  GNOMEUIINFO_MENU_CLEAR_ITEM (on_clear1_activate, NULL),
  GNOMEUIINFO_SEPARATOR,
  GNOMEUIINFO_MENU_PROPERTIES_ITEM (on_properties1_activate, NULL),*/
  GNOMEUIINFO_END
};

static GnomeUIInfo view1_menu_uiinfo[] =
{
  GNOMEUIINFO_END
};

static GnomeUIInfo settings1_menu_uiinfo[] =
{
   //GNOMEUIINFO_MENU_PREFERENCES_ITEM (on_preferences1_activate, NULL),
  GNOMEUIINFO_END
};

static GnomeUIInfo help1_menu_uiinfo[] =
{
  GNOMEUIINFO_MENU_ABOUT_ITEM (about_event, NULL),
  GNOMEUIINFO_END
};

static GnomeUIInfo menubar1_uiinfo[] =
{
  GNOMEUIINFO_MENU_FILE_TREE (file1_menu_uiinfo),
//  GNOMEUIINFO_MENU_EDIT_TREE (edit1_menu_uiinfo),
//  GNOMEUIINFO_MENU_VIEW_TREE (view1_menu_uiinfo),
  GNOMEUIINFO_MENU_SETTINGS_TREE (settings1_menu_uiinfo),
  GNOMEUIINFO_MENU_HELP_TREE (help1_menu_uiinfo),
  GNOMEUIINFO_END
};


static GtkWidget*
create_mdi ()
{
  GUIDocument *doc;
  mdi = GNOME_MDI(gnome_mdi_new ("vflow", _("vflow")));
  mdi->tab_pos = GTK_POS_TOP;
  gtk_object_set_data (GTK_OBJECT (mdi), "mdi", mdi);
  gtk_signal_connect(GTK_OBJECT(mdi), "remove_child", GTK_SIGNAL_FUNC(remove_doc_cb), NULL);

  //gnome_mdi_set_mode (mdi, GNOME_MDI_DEFAULT_MODE);
  gnome_mdi_set_mode (mdi, GNOME_MDI_NOTEBOOK);
  gnome_mdi_set_menubar_template (mdi, menubar1_uiinfo);
  gnome_mdi_set_toolbar_template (mdi, toolbar_data);
  

  //runButton= toolbar_data[5].widget;
  //stopButton= toolbar_data[6].widget;

  gnome_mdi_set_child_menu_path (mdi, GNOME_MENU_FILE_STRING);
  gnome_mdi_set_child_list_path (mdi, GNOME_MENU_FILES_PATH);


  //cerr << "open\n";
  gnome_mdi_open_toplevel(mdi);

  /*GtkWidget *w = gnome_mdi_get_toolbar_info (gnome_mdi_get_active_window(mdi))[6].widget;
    gtk_widget_set_sensitive(w,false);*/
   set_run_mode(false);
  return NULL;
}





void on_segfault(int sig)
{
   static pthread_t last;
   static bool in_segfault=false;
   if (in_segfault)
   {
      cerr << "nested segfaults caught (that's nasty!)\n";
      exit(1);
   }
   in_segfault=true;
   if (pthread_equal (GUIDocument::runThread, pthread_self()))
   {
      if (pthread_equal (GUIDocument::runThread, last))
      {
	 cerr << "same thread segfaulted twice... something's wrong" << endl;
	 abort();
      }
      last = GUIDocument::runThread;
      cerr << "segfault caught in user program\n";
      gdk_threads_enter();
      gnome_error_dialog("The user program caused a segmentation violation.\nMemory corruption might have occured, so it is recommended\nto restart Overflow (unless you know what you're doing).");
      gdk_threads_leave();
      in_segfault=false;
      //_exit(NULL);
      pthread_exit(NULL);
//pthread_cancel (GUIDocument::runThread);
   } else {
      cerr << "Overflow just crashed... you should have saved :-(\n";
      gnome_error_dialog("Overflow just crashed... you should have saved :-(");
      abort();
   }
   in_segfault=false;
}

#include "ExternalApp.h"

int
main (int argc, char *argv[])
{
   try {
      scanDL();
   } 
   catch (BaseException *e) {
      e->print();
      delete e;
      exit(1);
   } catch (...) {cerr << "caught something\n"; exit(1);}
   
   try {
      
      UIDocument::loadAllInfo();
      GtkWidget *vflow;
      
      g_thread_init(NULL); 
      
      gnome_init ("vflow", VERSION, argc, argv);
      setlocale (LC_NUMERIC, "C");
      signal(11,on_segfault);     
      //signal(11,SIG_DFL);
      
      create_mdi();
      
      if (argc > 1)
      {
	 for (int i=1;i<argc;i++)
	 {
	    GUIDocument *doc = new GUIDocument("Untitled");
	    gnome_mdi_add_child (mdi, GNOME_MDI_CHILD (doc->getMDIChild()));
	    gnome_mdi_add_view  (mdi, GNOME_MDI_CHILD (doc->getMDIChild()));
	    doc->setFullPath(argv[i]);
	    doc->load();
	    doc->resetModified();
	 }
      } else {
	 GUIDocument *doc = new GUIDocument("Untitled");
	 gnome_mdi_add_child (mdi, GNOME_MDI_CHILD (doc->getMDIChild()));
	 gnome_mdi_add_view  (mdi, GNOME_MDI_CHILD (doc->getMDIChild()));
      }
      //cerr << "gtk_main\n";
      //ExternalApp::startApp("Visix");  
      
      gdk_threads_enter(); 
      gtk_main ();
      gdk_threads_leave(); 
   }
   catch (BaseException *e) {
      e->print();
      delete e;
      exit(1);
   } catch (...) {
      cerr << "Unhandled exception\n"; exit(1);
   }
   
   return 0;
}

