#ifndef PROBE_H
#define PROBE_H


#include "Node.h"
#include <gnome.h>
//
//#ifdef HAVE_SEMAPHORE_H
//#include <semaphore.h>
//#endif

#include <pthread.h>

#ifdef HAVE_PTHREAD_CANCEL
#define NO_CANCEL pthread_setcanceltype(PTHREAD_CANCEL_DEFERRED, NULL);
#else
#define NO_CANCEL
#endif

#ifdef HAVE_PTHREAD_CANCEL
#define SET_CANCEL pthread_setcanceltype(PTHREAD_CANCEL_ASYNCHRONOUS, NULL);
#else
#define SET_CANCEL
#endif

class Probe : public Node {
  protected:

   ObjectRef inputValue;

   /**The ID of the 'output' output*/
   int outputID;

   /**The ID of the 'output' output*/
   int inputID;

   GtkWidget *window1;
   GtkWidget *button16;
   GtkWidget *button17;
   GtkWidget *button18;
   GtkWidget *button19;
   GtkWidget *vbox2;
   GtkWidget *entry1;

   pthread_mutex_t mutex;
   pthread_cond_t cond;
   int nbClick;
   //sem_t sem;

   int breakAt;

   int skip;

   bool traceEnable;

   bool displayEnable;
  public:
   Probe(string nodeName, ParameterSet params);

   virtual ~Probe();

   /**Class specific initialization routine.
      Each class will call its subclass specificInitialize() method*/
   virtual void specificInitialize();

   /**Class reset routine.
      Each class will call its superclass reset() method*/
   virtual void reset();

   /**Ask for the node's output which ID (number) is output_id 
      and for the 'count' iteration */
   virtual ObjectRef getOutput(int output_id, int count); 

   /**Standard request-passing method between nodes during initialization*/
   virtual void request(int outputID, const ParameterSet &req) {
     inputs[inputID].node->request(inputs[inputID].outputID,req);
   }

   virtual void trace();
   
   virtual void next();

   virtual void cont();
      
   virtual void setBreak();

   virtual void display();

   virtual void show_hide();

protected:
   /**Default constructor, should not be used*/
   Probe() {throw new GeneralException("Probe copy constructor should not be called",__FILE__,__LINE__);}

};

#endif

