## Copyright (C) 1999  Jean-Marc Valin
##
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2, or (at your option)
## any later version.
##
## This program is distributed in the hope that it will be useful, but
## WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
## General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with this file.  If not, write to the Free Software Foundation,
## 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

## usage:  xmensurewin(callsubplot)
##
## Matlab equivalent to pcolor
## Uses OpenGL to display 2D graphic

## Author:  Jean-Marc Valin <valj01@gel.usherb.ca>

function pcolor(x)

global pcolor_pipe;
global pcolor_pid;

if !exist("pcolor_pipe")
     pcolor_pipe=0;
end


if (pcolor_pipe == 0)
   [pcolor_pipe,dummy,pcolor_pid] = popen2 ("pcolor","");
else
   [PID, MSG] = waitpid (pcolor_pid, 1);
   #printf ("received PID %d, MSG %s, pid=%d\n", PID, MSG, pcolor_pid);
   if (PID < 0)
      [pcolor_pipe,dummy,pcolor_pid] = popen2 ("pcolor","");
   end
end

#fprintf (pcolor_pipe, "COLORSCALE BW\n");
fprintf (pcolor_pipe, "DATA\n");
fprintf (pcolor_pipe, "%d %d\n", size(x,1), size(x,2));
fprintf (pcolor_pipe, "%g\n", x');
fprintf (pcolor_pipe, "\n");
fflush (pcolor_pipe);

