// Copyright (C) 1999 Jean-Marc Valin
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this file.  If not, write to the Free Software Foundation,
// 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

#include "Node.h"

class IsValid;
DECLARE_NODE(IsValid)
/*Node

 * @name IsValid
 * @category Logic
 * @description Verifies if an object is valid

 * @input_name INPUT
 * @input_description The input object

 * @output_name OUTPUT
 * @output_description TRUE if the object is valid
 * @output_type bool

END*/


class IsValid : public Node {
protected:
   ///The ID of the 'output' output
   int outputID;

   ///The ID of the 'input' input
   int inputID;

   ///The true ObjectRef used to return true
   ObjectRef trueObject;

   ///The false ObjectRef used to return true
   ObjectRef falseObject;

public:
   ///Constructor, takes the name of the node and a set of parameters
   IsValid(string nodeName, ParameterSet params) : Node (nodeName,params)
   {
      inputID = addInput ("INPUT");
      outputID = addOutput ("OUTPUT");
      trueObject = ObjectRef (new Bool(true));
      falseObject = ObjectRef (new Bool(false));
   }
   
   virtual void specificInitialize()
   {
      this->Node::specificInitialize();
   }

   virtual ObjectRef getOutput(int output_id, int count);
};

ObjectRef IsValid::getOutput(int output_id, int count)
{
   NodeInput input = inputs[inputID];
   if (input.node->getOutput(input.outputID,count)->status && count > 15)
      return falseObject;
   else return trueObject;
}
