// Copyright (C) 1999 Jean-Marc Valin
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this file.  If not, write to the Free Software Foundation,
// 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

#include "FrameOperation.h"
#include "RotatingFrameBuffer.h"
//#include "GrowingFrameBuffer.h"

FrameOperation::FrameOperation(string nodeName, const ParameterSet &params) 
   : BufferedNode(nodeName, params)
{
   cerr << "oops... there's one\n";
   outputID = addOutput("OUTPUT");
   if (parameters.exist("OUTPUTLENGTH"))
      outputLength = dereference_cast <int> (parameters.get("OUTPUTLENGTH"));
   else outputLength = dereference_cast <int> (parameters.get("LENGTH"));
}

void FrameOperation::initializeBuffers()
{
   for (int i=0;i<outputs.size();i++)
   {
      outputs[i].buffer = ObjectRef(new RotatingFrameBuffer<float> (outputLength, outputs[i].lookAhead+outputs[i].lookBack+1));
   }
   output=outputs[outputID].buffer;
}


void FrameOperation::specificInitialize()
{
   //cerr << "FrameOperation initialize...\n";
   this->BufferedNode::specificInitialize();
}

void FrameOperation::reset()
{
   this->BufferedNode::reset();
}
