// Copyright (C) 1999 Jean-Marc Valin
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this file.  If not, write to the Free Software Foundation,
// 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

#ifndef ROTATING_FRAME_BUFFER_H
#define ROTATING_FRAME_BUFFER_H

#include <vector>
#include "Vector.h"
#include "Object.h"
#include "Buffer.h"
#include "net_types.h"

template <class T>
class RotatingFrameBuffer : public Buffer
{
public:
   RotatingFrameBuffer(int vLength, int bLength=1)
      : Buffer (bLength)
      , vectorLength(vLength)
   {
      for (int i=0;i<bLength;i++) 
      {
	 data[i]= ObjectRef (Vector<T>::alloc(vLength));
         //data[i]= ObjectRef (new Vector<T> (vLength));
         data[i]->status = Object::nil;
      }
   }
   
   inline ObjectRef &operator[] (int ind) 
   {
      if (ind > currentPos)
      {
         for (int i=currentPos+1;i<=ind;i++)
            data[ind % bufferLength]->status = Object::nil;
         currentPos = ind;
      }
      if (ind < 0 || ind <= currentPos-bufferLength)
      {
         //cerr << "ind = " << ind << endl;
         throw new BufferException (this, "trying to access non-existing element",ind);
      }
      return data[ind % bufferLength];
   }
   
   inline ObjectRef operator[] (int ind) const
   {
      if (ind > currentPos)
      {
         for (int i=currentPos+1;i<=ind;i++)
            data[ind % bufferLength]->status = Object::nil;
         currentPos = ind;
      }
      if (ind < 0 || ind <= currentPos-bufferLength)
      {
         throw new BufferException (this, "trying to access non-existing element",ind);
      }
      return data[ind % bufferLength];
   }

protected:
   int vectorLength;
};

#endif
