// Copyright (C) 1999 Dominic Letourneau
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this file.  If not, write to the Free Software Foundation,
// 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

#ifndef _PATHLIST_H_
#define _PATHLIST_H_


#include "Node.h"
#include <queue>

/** The PathList class. */
class PathList : public Node {

public:

   /** The constructor with a nodeName and a parameter set 
       parameters:   PATH     ->The path 
                     EXTENSION->The file extension we want to find
    */
   PathList (string nodeName, ParameterSet params);

   /** The getOutput method overloader from Node */
   virtual ObjectRef getOutput (int output_id, int count);
   
   void specificInitialize() {processCount=-1;Node::specificInitialize();}

   void reset() {processCount=-1;Node::reset();}

private:
   int processCount;

   /// The filename Output (PATH + FILENAME)
   ObjectRef fullName;

   ///The filename only (FILENAME)
   ObjectRef shortName;

   ///The outputID of the full path
   int fullPathID;

   ///The outputID of the file name
   int fileNameID;

   /// The filename queue
   queue<string> fileQueue;
 
   /// The path of the directory listing
   string path;

   /// The extension of the file we want to get
   string extension;

   /// The default constructor
   PathList() {
      throw new NodeException (NULL,"The default constructor should not be called from PathList",__FILE__,__LINE__);
   }

   ///Reads the path given in a parameter (using the file extension)
   void ReadPath();

   ///Removes the path from a full file name
   string removePath(const string &fullName);
};

#endif
