// Copyright (C) 1999 Dominic Letourneau
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this file.  If not, write to the Free Software Foundation,
// 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

#ifndef _NETEXEC_H_
#define _NETEXEC_H_

#include "Node.h"

/** Instead of calling a function, this node calls an executable and
    pipe the output (stdout) into a string.
    @author Dominic Letourneau
    @version 1.0
*/
class NetExec : public Node {

public:

   /** The constructor with a nodeName and a parameter set */
   NetExec (string nodeName, ParameterSet params);

   /** The getOutput method overloaded from Node */
   virtual ObjectRef getOutput (int output_id, int count);
   
   void specificInitialize() {processCount=-1;Node::specificInitialize();}

   void reset() {processCount=-1;Node::reset();}
private:
   
   int processCount;

   /// The list output
   ObjectRef output;

   /// The status output
   ObjectRef status;
   
   /// CommandString
   int CmdInputID;

   /// Args
   int ArgsInputID;

   /// Status output
   int StatusOutID;

   /// String output
   int StringOutID;

   /// The default constructor
   NetExec() {
      throw new NodeException (NULL,"The default constructor should not be called from NetExec",__FILE__,__LINE__);
   }
};



#endif
