// Copyright (C) 1999 Dominic Letourneau
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this file.  If not, write to the Free Software Foundation,
// 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

#ifndef _NOT_H_
#define _NOT_H_

#include "Node.h"
#include "Exception.h"

/** 
    The NOT Node takes an input (bools) and returns the
    NOT result.
    - INPUTS : INPUT (bool)
    - OUTPUTS: OUTPUT (bool)
    @author Dominic Letourneau
    @version 1.0
 */
class NOT : public Node {

public:

   ///Constructor, takes the name of the node and a set of parameters
   NOT(string nodeName, ParameterSet params);

   /**Ask for the node's output which ID (number) is output_id 
      and for the 'count' iteration */
   virtual ObjectRef getOutput(int output_id, int count); 

   void specificInitialize() {processCount=-1;Node::specificInitialize();}

   void reset() {processCount=-1;Node::reset();}


protected:
   
   /// The input ID
   int inputID;
   
   /// The output ID
   int outputID;

   int processCount;

   ///the bool output (NOT)
   ObjectRef output;

   ///Default constructor, should not be used
   NOT() {throw(GeneralException("NOT default constructor should not be called",__FILE__,__LINE__));}

};
#endif
