// Copyright (C) 1999 Jean-Marc Valin
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this file.  If not, write to the Free Software Foundation,
// 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

#ifndef FRAME_OPERATION_H
#define FRAME_OPERATION_H

#include "Node.h"
#include "Object.h"
#include "Vector.h"
#include "BufferedNode.h"

/**Class for nodes that operate on frames (typically audio)
   @author Jean-Marc Valin
   @version 1.0
*/
class FrameOperation : public BufferedNode {
protected:
   /**Length of output frames*/
   int outputLength;

   /**Output buffer*/
   ObjectRef output;

   /**outputID*/
   int outputID;

public:
   
   /**Constructor, takes the name of the node and a set of parameters*/
   FrameOperation(string nodeName, const ParameterSet &params);

   /**Class specific initialization routine.
      Each class will call its subclass specificInitialize() method*/
   virtual void specificInitialize();

   /**Class reset routine.
      Each class will call its superclass reset() method*/
   virtual void reset();

   /***/
   virtual void initializeBuffers();

   /**Ask for the node's output which ID (number) is output_id 
      and for the 'count' iteration */
   virtual void calculate(int output_id, int count, Buffer &buf) {throw "I'm fucked up";}

protected:
   /**Default constructor, should not be used*/
   FrameOperation() {throw new GeneralException("FrameOperation copy constructor should not be called",__FILE__,__LINE__);}

};


#endif
