// Copyright (C) 1999 Jean-Marc Valin
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this file.  If not, write to the Free Software Foundation,
// 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

#include "Node.h"
#include "ObjectRef.h"
#include <math.h>

class Sync;
DECLARE_NODE(Sync)
/*Node

 * @name Sync
 * @category Flow
 * @description No description available

 * @input_name INPUT
 * @input_description No description available

 * @output_name OUTPUT
 * @output_description No description available

 * @parameter_name RATIO
 * @parameter_description No description available

END*/


class Sync : public Node {
protected:
   /**The ID of the 'output' output*/
   int outputID;

   /**The ID of the 'input' input*/
   int inputID;

   /**input/output count ratio*/
   float ratio;
public:
   ///Constructor, takes the name of the node and a set of parameters
   Sync(string nodeName, ParameterSet params) : Node (nodeName,params)
   {
      inputID = addInput ("INPUT");
      outputID = addOutput ("OUTPUT");
      ratio = dereference_cast<float> (parameters.get("RATIO"));
   }
   
   virtual void specificInitialize()
   {
      this->Node::specificInitialize();
      
      ParameterSet req;
      req.add("LOOKAHEAD", ObjectRef(new Int(floor (ratio))));
      inputs[inputID].node->request(inputs[inputID].outputID, req);

   }

   virtual void reset()
   {
      this->Node::reset();
   }

   virtual ObjectRef getOutput(int output_id, int count);
   

   void request(int outputID, const ParameterSet &req)
   {
      //cerr << "name = " << name << " this = " << this << " outputID = " << outputID << endl;   cerr << "lookahead = " << outputs[outputID].lookAhead << " lookback = " << outputs[outputID].lookBack << endl;   
      
      if (req.exist("LOOKAHEAD"))
      {
	 ParameterSet p;
	 p.add("LOOKAHEAD", ObjectRef(new Int (1+ratio*dereference_cast<int> (req.get("LOOKAHEAD")))));
	 inputs[inputID].node->request(inputs[inputID].outputID,p);
      }
      if (req.exist("LOOKBACK"))
      {
	 ParameterSet p;
	 p.add("LOOKBACK", ObjectRef(new Int (1+ratio*dereference_cast<int> (req.get("LOOKBACK")))));
	 inputs[inputID].node->request(inputs[inputID].outputID,p);
      }
      //if (req.exist("CACHEALL"))
	 
      this->Node::request(outputID,req);
      
   }
      

};

ObjectRef Sync::getOutput(int output_id, int count)
{
   NodeInput input = inputs[inputID];
   return input.node->getOutput(input.outputID,int(floor(.5+count*ratio)));
}
