// Copyright (C) 1999 Dominic Letourneau
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this file.  If not, write to the Free Software Foundation,
// 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
#include "MMIAccumulator.h"

DECLARE_NODE(MMIAccumulator)
/*Node
 *
 * @name MMIAccumulator
 * @category VQ
 * @description No description available
 *
 * @input_name INPUT
 * @input_description No description available
 *
 * @output_name OUTPUT
 * @output_description No description available
 *
END*/


MMIAccumulator::MMIAccumulator(string nodeName, const ParameterSet &params) 
   : Node(nodeName, params)
{
   inputID = addInput("INPUT");
   outputID = addOutput("OUTPUT");
}

void MMIAccumulator::specificInitialize()
{
   processCount=-1;
   this->Node::specificInitialize();
   accum = ObjectRef(new Vector<ObjectRef>);
}

void MMIAccumulator::reset() 
{   
   processCount=-1;
   this->Node::reset();
   accum = ObjectRef(new Vector<ObjectRef>);  
}

ObjectRef MMIAccumulator::getOutput(int output_id, int count) {

   try {
      //cerr << "MMIAccumulator::getOutput " << count << endl;
      if (count > processCount) {
         
         for (int i = processCount + 1; i <= count; i++) {

            //updating the vector until processCount == count
            NodeInput input = inputs[inputID];
            ObjectRef inputResult;        
            inputResult = input.node->getOutput(input.outputID, i); 
            //new element into our accumulator
      
            Vector<ObjectRef> &tmp = object_cast<Vector<ObjectRef> >(accum);
            //cerr << "Inserting... " << i << endl;
            tmp.insert(tmp.end(),inputResult);
         }

         processCount = count;
         
      }
   }
   catch (BaseException *e) {    
      //e->print();
      throw e->add(new NodeException (NULL,"Caught Exception in MMIAccumulator getOutput",__FILE__,__LINE__));
   }
   
   return accum;
}
