// Copyright (C) 1999 Dominic Letourneau
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this file.  If not, write to the Free Software Foundation,
// 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
#include "Histogram.h"

DECLARE_NODE(Histogram)
/*Node

 * @name Histogram
 * @category VQ
 * @description No description available

 * @input_name INPUT
 * @input_description No description available

 * @output_name OUTPUT
 * @output_description No description available

 * @parameter_name LENGTH
 * @parameter_description No description available

END*/


Histogram::Histogram(string nodeName, const ParameterSet &params) 
   : Node(nodeName, params)
{
   inputID = addInput("INPUT");
   outputID = addOutput("OUTPUT");

   size = dereference_cast<int>(parameters.get("LENGTH"));
}

void Histogram::specificInitialize()
{
   processCount=-1;
   this->Node::specificInitialize();
   Vector<int> *temp = new Vector<int> (size,0);
   histogram = ObjectRef(temp);
}

void Histogram::reset() 
{
   processCount=-1;
   this->Node::reset();
   Vector<int> *temp = new Vector<int> (size,0);
   histogram = ObjectRef(temp);
}

ObjectRef Histogram::getOutput(int output_id, int count) {

   try {
      if (count > processCount) {
         
         for (int i = processCount + 1; i <= count; i++) {

            //updating the vector until processCount == count
            NodeInput input = inputs[inputID];
            ObjectRef inputResult;        
            inputResult = input.node->getOutput(input.outputID, i); 
            if (inputResult->status == Object::valid)
            {
               int value = dereference_cast<int> (inputResult);

               //increment value
               if (value < size) {
                  (object_cast<Vector<int> >(histogram))[value]++;
               } else {
                  cerr << "value = " << value << ", size = " << size << endl;
                  throw new NodeException(this,"Invalid index for histogram",__FILE__,__LINE__);
               }
            }
         }

         processCount = count;
         
      }
   }
   catch (BaseException *e) {    
      //e->print();
      throw e->add(new NodeException (NULL,"Caught Exception in Histogram getOutput",__FILE__,__LINE__));
   }
   
   return histogram;
}
