// Copyright (C) 1999 Jean-Marc Valin
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this file.  If not, write to the Free Software Foundation,
// 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

#include "BufferedNode.h"
#include "Buffer.h"
#include "Vector.h"
#include <stdlib.h>

class CAllPole;

DECLARE_NODE(CAllPole)
/*Node

 * @name CAllPole
 * @category Signal:DSP
 * @description No description available

 * @input_name INPUT
 * @input_description No description available

 * @input_name FILTER
 * @input_description No description available

 * @output_name OUTPUT
 * @output_description No description available

END*/


class CAllPole : public BufferedNode {
   
   int inputID;
   int outputID;
   int filterID;

public:
   CAllPole(string nodeName, ParameterSet params)
   : BufferedNode(nodeName, params)
   {
      inputID = addInput("INPUT");
      filterID = addInput("FILTER");
      outputID = addOutput("OUTPUT");
      
   }

   virtual void specificInitialize()
   {
      outputs[outputID].lookBack += 1;
      this->BufferedNode::specificInitialize();
   }

   void calculate(int output_id, int count, Buffer &out)
   {
      ObjectRef inputValue = getInput(inputID, count);
      ObjectRef filterValue = getInput(filterID, count);

      if (inputValue->status != Object::valid)
      {
	 out[count] = inputValue;
         return;
      }

      const Vector<float> &in = object_cast<Vector<float> > (inputValue);
      int inputLength = in.size();

      Vector<float> &output = *Vector<float>::alloc(inputLength);
      out[count] = &output;

      for (int i=0;i<inputLength;i++)
         output[i]=in[i];

      if (filterValue->status != Object::valid)
      {
         return;
      }

      const Vector<float> &filter = object_cast<Vector<float> > (filterValue);
      const Vector<float> *past;
      bool can_look_back = false;
      if (count > 0)   
      {
         ObjectRef pastInputValue = this->getOutput(outputID, count-1);
         if (pastInputValue->status == Object::valid)
         {
            can_look_back=true;
            past = &object_cast<Vector<float> > (pastInputValue);
         }      
      }      
      

      int size = filter.size();

      if (can_look_back)
      {
         for (int i=0;i<size-1;i++)
         {
            int j, k;
            for (j=inputLength-1, k=1+i; k<size ; j--, k++)
            {
               output[i]-=(*past)[j]*filter[k];
            }         
         }
      }
      
      for (int i=0;i<inputLength;i++)
      {
         int j, k;
         for (j=i-1, k=1;j>=max(0,i-size+1) ; j--, k++)
            output[i]-=output[j]*filter[k];
      }
      for (int i=0;i<inputLength;i++)
         output[i]/=filter[0];
   }

};
