// Copyright (C) 1999 Dominic Letourneau
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this file.  If not, write to the Free Software Foundation,
// 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

#ifndef HISTOGRAM_H
#define HISTOGRAM_H

#include "Node.h"
#include "Vector.h"

///class Histogram
class Histogram : public Node {

protected:

   ObjectRef histogram;

   ///Our InputID
   int inputID;

   ///Out OutputID
   int outputID;

   ///The histogram size
   int size;

   int processCount;

public:

   ///Constructor, takes the name of the node and a set of parameters
   Histogram(string nodeName, const ParameterSet &params);

   /**Class specific initialization routine.
      Each class will call its subclass reset() method*/
   virtual void reset();

   /**Ask for the node's output which ID (number) is output_id 
      and for the 'count' iteration */
   virtual ObjectRef getOutput(int output_id, int count); 

   /**Class specific initialization routine.
      Each class will call its subclass specificInitialize() method*/
   virtual void specificInitialize();

protected:
   ///Default constructor, should not be used
   Histogram() {throw new GeneralException("Histogram default constructor should not be called",__FILE__,__LINE__);}
};

#endif
