#include "Cell.h"
#include <fstream>
template <class T>
float cosDistance (const vector<T> &v1, const vector<T> &v2)
{
   T v1v2 = 0;
   T v1v1 = 0;
   T v2v2 = 0;
   for(int i=0;i<v1.size();i++)
   {
      v1v2 += v1[i]*v2[i];
      v1v1 += v1[i]*v1[i];
      v2v2 += v2[i]*v2[i];
   }
   return float(v1v2)/sqrt(float(v1v1)*float(v2v2));
}

main()
{
   int i;
   vector <pair<int, float *> > dat(6);
   for (i=0;i<6;i++)
   {
      dat[i].second=new float [2];
      dat[i].first = 0;
   }
   dat[0].second[0] = 0;
   dat[0].second[1] = 0;
   
   dat[1].second[0] = 0;
   dat[1].second[1] = 1;
   dat[1].first=1;
   
   dat[2].second[0] = 1;
   dat[2].second[1] = 1;

   dat[3].second[0] = 1;
   dat[3].second[1] = 0;
   dat[3].first=1;

   dat[4].second[0] = 0.2;
   dat[4].second[1] = 0.4;

   dat[5].second[0] = .8;
   dat[5].second[1] = 0.4;
   dat[5].first=1;

   Cell cell(2,2);
   
   cell.recursiveSplit(dat, 2);
   int numberCells = cell.setNumbering();
   cerr << "number of cells: " << numberCells << endl;
   float a[2]={0.5,0.5};
   cerr << "a belongs to: " << cell.belongs(a) << endl;

   vector<float *> f(6);
   for (i=0;i<5;i++)
      f[i]=dat[i].second;
   f[5]=a;
   vector<int> templ(4,0);
   vector<int> templ2(4,-1);
   templ2[0]=3;
   
   
   cell.calcTemplate(f,templ);
   for (i=0;i<4;i++)
      cerr << templ[i] << " ";
   cerr << endl;
   
   cerr << "distance: " << cosDistance(templ,templ2) << endl;
   //cell.printOn(cout);

   {
      ofstream of("tata.mmi");
      of << cell;
   }
   {
      ifstream ifs("tata.mmi");
      Cell cell2;
      ifs >> cell2;
      ofstream of2("tata2.mmi");
      of2 << cell2;
   }
   cerr << "fini\n";
}
