// Copyright (C) 1999 Jean-Marc Valin
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this file.  If not, write to the Free Software Foundation,
// 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

#include "BufferedNode.h"
#include "Buffer.h"
#include "Vector.h"
#include "kmeans.h"
#include <math.h>

#ifdef HAVE_FLOAT_H
#include <float.h>
#endif

class VQCloseness;

DECLARE_NODE(VQCloseness)
/*Node
 *
 * @name VQCloseness
 * @category VQ
 * @description No description available
 *
 * @input_name INPUT
 * @input_description No description available
 *
 * @input_name VQ
 * @input_description No description available
 *
 * @output_name OUTPUT
 * @output_description No description available
 *
END*/


class VQCloseness : public BufferedNode {
   
   int inputID;
   int VQinputID;
   int outputID;

public:
   VQCloseness(string nodeName, ParameterSet params)
   : BufferedNode(nodeName, params)
   {
      inputID = addInput("INPUT");
      VQinputID = addInput("VQ");
      outputID = addOutput("OUTPUT");
   }

   void calculate(int output_id, int count, Buffer &out)
   {
      NodeInput input = inputs[inputID];
      NodeInput VQInput = inputs[VQinputID];

      ObjectRef VQValue = VQInput.node->getOutput(VQInput.outputID, count);

      if (VQValue->status != Object::valid)
      {
         out[count] = VQValue;
         return;
      }

      ObjectRef inputValue = input.node->getOutput(input.outputID, count);

      if (inputValue->status != Object::valid)
      {
         out[count] = inputValue;
         return;
      }
      const Vector<float> &in = object_cast<Vector<float> > (inputValue);
      int inputLength = in.size();
      const KMeans &vq = object_cast<KMeans> (VQValue);

      int outputLength = vq.nbClasses();
      Vector<float> &output = *Vector<float>::alloc(outputLength);
      out[count] = &output;

      
      vq.calcDist(&in[0], &output[0]);

      float sum = 10*FLT_MIN;
      float epsilon = 100*FLT_MIN;
      for (int i=0;i<outputLength;i++)
      {
	 //float tmp = 1/((output[i]*output[i]*output[i]*output[i])+epsilon);
         float tmp = exp(-output[i]);
	 output[i]=tmp;
	 sum += tmp;
      }
      for (int i=0;i<outputLength;i++)
      {
	 output[i] /= sum;
	 //output[i] = 2*output[i] - 1;
      }
   }

};
