// Copyright (C) 1999 Jean-Marc Valin
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this file.  If not, write to the Free Software Foundation,
// 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

#include "covariance.h"
#include "gmm.h"
#include <iostream>
#include <fstream>
#include <typeinfo>
#include "BaseException.h"
#include "acoustic_model.h"

using namespace std;

int main()
{
   try {
      int i, iter;
      
      int N=100;
      int D=3;
      int G=1;
      
      
      GMM g(G,D,NewDiagonalCovariance);
      vector<float * > frms(N);
      for (i=0;i<frms.size();i++)
      {
         frms[i]=new float [D];
         for (unsigned int j=0;j<D;j++)
         {
            frms[i][j]=float((rand()%1000)/100.0);
         }
      }
      
      g.init(frms);
      
      //g.to_real();
      
      for (iter=0;iter<7;iter++)
      {
         g.split1();
         //g.binary_split();

         g.kmeans1(frms, 10);

         //g.to_real();
         
      }

      g.kmeans1(frms, 10);
      g.to_real();
      
      {
         ofstream file("test.gmm");
         file << g;
      }
      {
         ifstream file("test.gmm");
         ofstream file2("test2.gmm");
         ObjectRef tmp;
         file >> tmp;
         file2 << tmp;
      }
      //file << g << endl;
      {
         ifstream file("tata.mdl");
         ofstream file2("test2.mdl");
         RCPtr<AcousticModel> tmp;
         file >> tmp;
         tmp->toIDs();
         tmp->toPtrs();
         file2 << tmp;
      }
      cerr << "fini\n";
   }
   catch (string str)
   {
      cerr << str << endl;
   }
   catch (char *str)
   {
      cerr << str << endl;
   }
   catch (BaseException *e)
   {
      e->print(cerr);
   } catch (...) {cerr << "Caught I don't know what there\n";}
}
