#!/usr/bin/env batchflow
<?xml version="1.0"?>
<Document>
  <Network type="subnet" name="MAIN">
    <Node name="node1" type="MAIN_LOOP" x="-441.000000" y="110.000000">
      <Parameter name="FRAME_SIZE" type="int" value="512"/>
      <Parameter name="FRAME_ADVANCE" type="int" value="256"/>
      <Parameter name="PS_SIZE" type="int" value="256"/>
      <Parameter name="DOWHILE" type="bool" value=""/>
    </Node>
    <Node name="node2" type="SaveAs" x="-156.000000" y="95.000000">
      <Parameter name="FILENAME" type="string" value="si.gmm"/>
    </Node>
    <Node name="node4" type="Discard" x="-46.000000" y="95.000000"/>
    <Node name="node5" type="NewAccumulator" x="-674.000000" y="146.000000"/>
    <Node name="node6" type="ExecStream" x="-584.000000" y="102.000000">
      <Parameter name="COMMAND" type="string" value="cat "/>
    </Node>
    <Node name="node7" type="Constant" x="-702.000000" y="101.000000">
      <Parameter name="VALUE" type="subnet_param" value="ARG1"/>
    </Node>
    <Node name="node3" type="GMMTrain" x="-270.000000" y="96.000000">
      <Parameter name="SPLIT_LEVELS" type="int" value="7"/>
    </Node>
    <Link from="node2" output="OUTPUT" to="node4" input="INPUT"/>
    <Link from="node5" output="OUTPUT" to="node1" input="ACCUM"/>
    <Link from="node6" output="OUTPUT" to="node1" input="INPUT"/>
    <Link from="node7" output="VALUE" to="node6" input="INPUT"/>
    <Link from="node1" output="OUTPUT" to="node3" input="FRAMES"/>
    <Link from="node3" output="OUTPUT" to="node2" input="INPUT"/>
    <NetOutput name="OUTPUT" node="node4" terminal="OUTPUT"/>
  </Network>
  <Network type="iterator" name="MAIN_LOOP">
    <Node name="node1" type="AudioStream" x="-302.000000" y="108.000000">
      <Parameter name="LENGTH" type="subnet_param" value="FRAME_SIZE"/>
      <Parameter name="ADVANCE" type="subnet_param" value="FRAME_ADVANCE"/>
      <Parameter name="ENCODING" type="string" value="LIN16"/>
      <Parameter name="STREAM_TYPE" type="string" value=""/>
      <Parameter name="REWIND" type="bool" value=""/>
    </Node>
    <Node name="node2" type="Window" x="-131.000000" y="101.000000">
      <Parameter name="LENGTH" type="subnet_param" value="FRAME_SIZE"/>
      <Parameter name="WINDOW" type="string" value="HANNING"/>
      <Parameter name="SYMETRIC" type="bool" value="true"/>
    </Node>
    <Node name="node3" type="FFT" x="-43.000000" y="100.000000"/>
    <Node name="node4" type="Mel" x="84.000000" y="99.000000">
      <Parameter name="INPUTLENGTH" type="subnet_param" value="PS_SIZE"/>
      <Parameter name="OUTPUTLENGTH" type="int" value="20"/>
      <Parameter name="SAMPLING" type="int" value="16000"/>
      <Parameter name="LOW" type="int" value="100"/>
      <Parameter name="HIGH" type="int" value="7000"/>
    </Node>
    <Node name="node5" type="PS" x="23.000000" y="99.000000"/>
    <Node name="node6" type="Log" x="233.000000" y="98.000000">
      <Parameter name="FAST" type="bool" value=""/>
    </Node>
    <Node name="node7" type="DCT" x="317.000000" y="97.000000">
      <Parameter name="LENGTH" type="int" value="20"/>
      <Parameter name="FAST" type="bool" value="true"/>
      <Parameter name="OUTPUTLENGTH" type="int" value=""/>
    </Node>
    <Node name="node8" type="Select" x="405.000000" y="156.000000">
      <Parameter name="START" type="int" value="0"/>
      <Parameter name="END" type="int" value="9"/>
    </Node>
    <Node name="node9" type="TimeFilter" x="504.000000" y="155.000000">
      <Parameter name="LENGTH" type="int" value="10"/>
      <Parameter name="FIR" type="string" value="&lt;Vector .2 .1 0 -.1 -.2&gt;"/>
      <Parameter name="IIR" type="string" value="&lt;Vector 1&gt;"/>
      <Parameter name="LOOKAHEAD" type="int" value="2"/>
    </Node>
    <Node name="node11" type="Concatenate" x="968.000000" y="106.000000"/>
    <Node name="node13" type="Select" x="510.000000" y="97.000000">
      <Parameter name="START" type="int" value="1"/>
      <Parameter name="END" type="int" value="15"/>
    </Node>
    <Node name="node14" type="Accumulate" x="1166.000000" y="114.000000"/>
    <Node name="node19" type="IF" x="1315.000000" y="51.000000">
      <Parameter name="PULL_ANYWAY" type="bool" value=""/>
    </Node>
    <Node name="node20" type="NOP" x="996.000000" y="197.000000"/>
    <Node name="node21" type="Constant" x="1172.000000" y="165.000000">
      <Parameter name="VALUE" type="int" value="1"/>
    </Node>
    <Node name="node23" type="Add" x="189.000000" y="98.000000"/>
    <Node name="node24" type="Constant" x="63.000000" y="142.000000">
      <Parameter name="VALUE" type="float" value="20000"/>
    </Node>
    <Node name="node_Greater_1" type="Greater" x="570.000000" y="37.000000"/>
    <Node name="node_Constant_1" type="Constant" x="377.000000" y="44.000000">
      <Parameter name="VALUE" type="float" value="2"/>
    </Node>
    <Node name="node_TimeEntropy_1" type="TimeEntropy" x="286.000000" y="-19.000000">
      <Parameter name="LOOKAHEAD" type="int" value="10"/>
      <Parameter name="LOOKBACK" type="int" value="10"/>
    </Node>
    <Node name="node_Index_1" type="Index" x="446.000000" y="-10.000000">
      <Parameter name="INDEX" type="int" value="0"/>
    </Node>
    <Link from="node2" output="OUTPUT" to="node3" input="INPUT"/>
    <Link from="node3" output="OUTPUT" to="node5" input="INPUT"/>
    <Link from="node5" output="OUTPUT" to="node4" input="INPUT"/>
    <Link from="node6" output="OUTPUT" to="node7" input="INPUT"/>
    <Link from="node7" output="OUTPUT" to="node8" input="INPUT"/>
    <Link from="node8" output="OUTPUT" to="node9" input="INPUT"/>
    <Link from="node7" output="OUTPUT" to="node13" input="INPUT"/>
    <Link from="node14" output="OUTPUT" to="node19" input="THEN"/>
    <Link from="node11" output="OUTPUT" to="node14" input="INPUT"/>
    <Link from="node20" output="OUTPUT" to="node14" input="ACCUM"/>
    <Link from="node21" output="VALUE" to="node19" input="ELSE"/>
    <Link from="node23" output="OUTPUT" to="node6" input="INPUT"/>
    <Link from="node24" output="VALUE" to="node23" input="INPUT2"/>
    <Link from="node4" output="OUTPUT" to="node23" input="INPUT1"/>
    <Link from="node1" output="AUDIO" to="node2" input="INPUT"/>
    <Link from="node_Index_1" output="OUTPUT" to="node_Greater_1" input="INPUT1"/>
    <Link from="node_Constant_1" output="VALUE" to="node_Greater_1" input="INPUT2"/>
    <Link from="node_TimeEntropy_1" output="OUTPUT" to="node_Index_1" input="INPUT"/>
    <Link from="node7" output="OUTPUT" to="node_TimeEntropy_1" input="INPUT"/>
    <Link from="node_Greater_1" output="OUTPUT" to="node19" input="COND"/>
    <Link from="node13" output="OUTPUT" to="node11" input="INPUT1"/>
    <Link from="node9" output="OUTPUT" to="node11" input="INPUT2"/>
    <NetInput name="INPUT" node="node1" terminal="INPUT"/>
    <NetInput name="ACCUM" node="node20" terminal="INPUT"/>
    <NetOutput name="OUTPUT" node="node20" terminal="OUTPUT"/>
    <NetOutput name="OUTPUT2" node="node19" terminal="OUTPUT"/>
    <NetOutput name="OUTPUT3" node="node11" terminal="OUTPUT"/>
    <NetCondition name="CONDITION" node="node1" terminal="NOT_EOF"/>
  </Network>
  <Parameter name="ARG1" type="string" value="/data/ntt/*/*/*"/>
</Document>
