#!/bin/sh
#
#   @(#)$Id: createWinDBstruct.sh,v 1.2 2004/08/30 20:12:04 joerg78 Exp $
#
#   cddbd - CD Database Protocol Server
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#

# This simple script will create empty directory/file structure in the Windows
# database format. This is meant to be used as a base for an "update" using
# the Windows Database Updater and the UNIX database mirror.

GENRES="blues classical country data folk jazz misc newage reggae rock soundtrack"
CURRENTDIR=`pwd`

CreateFiles()
{
    echo "Creating files in $1"
    counter=0
    while [ ${counter} -lt 255 ]
    do
        filename=$1/`printf "%02xto%02x" ${counter} ${counter}`;
        touch ${filename}
        counter=`expr ${counter} + 1`
    done
}

for genre in ${GENRES}
do
    WORKDIR=${CURRENTDIR}/${genre}
    mkdir -p ${WORKDIR}
    CreateFiles ${WORKDIR}
done



