// Borland C++ Builder
// Copyright (c) 1995, 2002 by Borland Software Corporation
// All rights reserved

// (DO NOT EDIT: machine generated header) 'QiSpectrumDisplay.pas' rev: 6.00

#ifndef QiSpectrumDisplayHPP
#define QiSpectrumDisplayHPP

#pragma delphiheader begin
#pragma option push -w-
#pragma option push -Vx
#include <QiCLXComponent.hpp>	// Pascal unit
#include <QiComponent.hpp>	// Pascal unit
#include <QiThreadTimers.hpp>	// Pascal unit
#include <QiCustomComponent.hpp>	// Pascal unit
#include <QiGPFunctions.hpp>	// Pascal unit
#include <QiTypes.hpp>	// Pascal unit
#include <QExtCtrls.hpp>	// Pascal unit
#include <QStdCtrls.hpp>	// Pascal unit
#include <QComCtrls.hpp>	// Pascal unit
#include <QControls.hpp>	// Pascal unit
#include <Variants.hpp>	// Pascal unit
#include <Classes.hpp>	// Pascal unit
#include <Types.hpp>	// Pascal unit
#include <QTypes.hpp>	// Pascal unit
#include <QClipbrd.hpp>	// Pascal unit
#include <QDialogs.hpp>	// Pascal unit
#include <QForms.hpp>	// Pascal unit
#include <QGraphics.hpp>	// Pascal unit
#include <Qt.hpp>	// Pascal unit
#include <TypInfo.hpp>	// Pascal unit
#include <Libc.hpp>	// Pascal unit
#include <SysUtils.hpp>	// Pascal unit
#include <Xlib.hpp>	// Pascal unit
#include <SysInit.hpp>	// Pascal unit
#include <System.hpp>	// Pascal unit

//-- user supplied -----------------------------------------------------------

namespace Qispectrumdisplay
{
//-- type declarations -------------------------------------------------------
struct TiSpectrumData
{
	double Value;
	double Peak;
	System::TDateTime PeakUpdateTime;
	Qgraphics::TColor Color;
} ;

class DELPHICLASS TiSpectrumDisplay;
class PASCALIMPLEMENTATION TiSpectrumDisplay : public Qicustomcomponent::TiCustomComponent 
{
	typedef Qicustomcomponent::TiCustomComponent inherited;
	
private:
	TiSpectrumData FData[1024];
	Qithreadtimers::TiThreadTimers* FDecayTimer;
	int FBarWidth;
	int FBarSpacing;
	int FBarHeight;
	int FBarBottom;
	int FStartLeft;
	bool FAutoSize;
	Classes::TNotifyEvent FOnAutoSize;
	bool FDoingAutoSize;
	int FBarCount;
	bool FDecayEnabled;
	int FDecayInterval;
	int FDecayInitialDelay;
	Qgraphics::TColor FBarColor;
	int FOuterMarginLeft;
	int FOuterMarginRight;
	int FOuterMarginBottom;
	int FOuterMarginTop;
	Qgraphics::TColor FPeakLineColor;
	bool FPeakShow;
	double FScaleMax;
	double FScaleMin;
	
protected:
	void __fastcall SetBarCount(const int Value);
	void __fastcall iSetAutoSize(const bool Value);
	void __fastcall SetDecayInitialDelay(const int Value);
	void __fastcall SetDecayEnabled(const bool Value);
	void __fastcall SetDecayInterval(const int Value);
	void __fastcall SetBarSpacing(const int Value);
	void __fastcall SetBarWidth(const int Value);
	void __fastcall SetBarColor(const Qgraphics::TColor Value);
	void __fastcall SetOuterMarginBottom(const int Value);
	void __fastcall SetOuterMarginLeft(const int Value);
	void __fastcall SetOuterMarginRight(const int Value);
	void __fastcall SetOuterMarginTop(const int Value);
	void __fastcall SetPeakLineColor(const Qgraphics::TColor Value);
	void __fastcall SetPeakShow(const bool Value);
	void __fastcall SetScaleMax(const double Value);
	void __fastcall SetScaleMin(const double Value);
	double __fastcall GetBarValue(int Index);
	Qgraphics::TColor __fastcall GetBarXColor(int Index);
	void __fastcall SetBarValue(int Index, const double Value);
	void __fastcall SetBarXColor(int Index, const Qgraphics::TColor Value);
	void __fastcall CalcRects(void);
	void __fastcall DecayTimerEvent(System::TObject* Sender);
	virtual void __fastcall SetBorderStyle(const Qitypes::TiBevelStyle Value);
	__property Classes::TNotifyEvent OnAutoSize = {read=FOnAutoSize, write=FOnAutoSize};
	void __fastcall DoAutoSize(void);
	virtual void __fastcall iPaintTo(Qgraphics::TCanvas* Canvas);
	virtual void __fastcall Loaded(void);
	
public:
	__fastcall virtual TiSpectrumDisplay(Classes::TComponent* AOwner);
	__fastcall virtual ~TiSpectrumDisplay(void);
	void __fastcall Clear(void);
	__property double BarValue[int Index] = {read=GetBarValue, write=SetBarValue};
	__property Qgraphics::TColor BarXColor[int Index] = {read=GetBarXColor, write=SetBarXColor};
	
__published:
	__property bool AutoSize = {read=FAutoSize, write=iSetAutoSize, default=1};
	__property int OuterMarginLeft = {read=FOuterMarginLeft, write=SetOuterMarginLeft, default=5};
	__property int OuterMarginTop = {read=FOuterMarginTop, write=SetOuterMarginTop, default=0};
	__property int OuterMarginRight = {read=FOuterMarginRight, write=SetOuterMarginRight, default=5};
	__property int OuterMarginBottom = {read=FOuterMarginBottom, write=SetOuterMarginBottom, default=0};
	__property bool DecayEnabled = {read=FDecayEnabled, write=SetDecayEnabled, default=1};
	__property int DecayInterval = {read=FDecayInterval, write=SetDecayInterval, default=40};
	__property int DecayInitialDelay = {read=FDecayInitialDelay, write=SetDecayInitialDelay, default=750};
	__property int BarCount = {read=FBarCount, write=SetBarCount, default=32};
	__property int BarWidth = {read=FBarWidth, write=SetBarWidth, default=6};
	__property int BarSpacing = {read=FBarSpacing, write=SetBarSpacing, default=1};
	__property Qgraphics::TColor BarColor = {read=FBarColor, write=SetBarColor, default=45056};
	__property bool PeakShow = {read=FPeakShow, write=SetPeakShow, default=1};
	__property Qgraphics::TColor PeakLineColor = {read=FPeakLineColor, write=SetPeakLineColor, default=16777215};
	__property double ScaleMin = {read=FScaleMin, write=SetScaleMin};
	__property double ScaleMax = {read=FScaleMax, write=SetScaleMax};
	__property BorderStyle  = {default=2};
	__property BackGroundColor  = {default=0};
	__property Transparent  = {default=0};
	__property Width  = {default=238};
	__property Height  = {default=125};
public:
	#pragma option push -w-inl
	/* TWidgetControl.CreateParented */ inline __fastcall TiSpectrumDisplay(Qt::QWidgetH* ParentWidget) : Qicustomcomponent::TiCustomComponent(ParentWidget) { }
	#pragma option pop
	
};


//-- var, const, procedure ---------------------------------------------------

}	/* namespace Qispectrumdisplay */
using namespace Qispectrumdisplay;
#pragma option pop	// -w-
#pragma option pop	// -Vx

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// QiSpectrumDisplay
