// Borland C++ Builder
// Copyright (c) 1995, 2002 by Borland Software Corporation
// All rights reserved

// (DO NOT EDIT: machine generated header) 'QiPlotAxis.pas' rev: 6.00

#ifndef QiPlotAxisHPP
#define QiPlotAxisHPP

#pragma delphiheader begin
#pragma option push -w-
#pragma option push -Vx
#include <QiPlotObjects.hpp>	// Pascal unit
#include <QiMath.hpp>	// Pascal unit
#include <QiGPFunctions.hpp>	// Pascal unit
#include <QiTypes.hpp>	// Pascal unit
#include <QiDateUtils.hpp>	// Pascal unit
#include <QMenus.hpp>	// Pascal unit
#include <QExtCtrls.hpp>	// Pascal unit
#include <QStdCtrls.hpp>	// Pascal unit
#include <QComCtrls.hpp>	// Pascal unit
#include <QControls.hpp>	// Pascal unit
#include <Variants.hpp>	// Pascal unit
#include <Classes.hpp>	// Pascal unit
#include <Types.hpp>	// Pascal unit
#include <QTypes.hpp>	// Pascal unit
#include <QClipbrd.hpp>	// Pascal unit
#include <QDialogs.hpp>	// Pascal unit
#include <QForms.hpp>	// Pascal unit
#include <QGraphics.hpp>	// Pascal unit
#include <Qt.hpp>	// Pascal unit
#include <TypInfo.hpp>	// Pascal unit
#include <Libc.hpp>	// Pascal unit
#include <SysUtils.hpp>	// Pascal unit
#include <Xlib.hpp>	// Pascal unit
#include <SysInit.hpp>	// Pascal unit
#include <System.hpp>	// Pascal unit

//-- user supplied -----------------------------------------------------------

namespace Qiplotaxis
{
//-- type declarations -------------------------------------------------------
#pragma option push -b-
enum TiQuadSide { iqsLeft, iqsRight, iqsTop, iqsBottom };
#pragma option pop

#pragma option push -b-
enum TiPlotTrackingStyle { iptsScaleMinMax, iptsScaleMax, iptsScaleMin, iptsScrollSmooth, iptsScrollPage, iptsExpandCollapse };
#pragma option pop

#pragma option push -b-
enum TiPlotAlignFirstStyle { ipafsMin, ipafsMax, ipafsAuto, ipafsNone };
#pragma option pop

#pragma option push -b-
enum TiPlotScaleType { ipstLinear, ipstLog10 };
#pragma option pop

#pragma option push -b-
enum TiPlotTextFormat { iptfValue, iptfExponent, iptfPrefix, iptfDateTime, iptfPrice32nds, iptfThousands };
#pragma option pop

#pragma option push -b-
enum TiPlotAxisMode { ipamScroll, ipamZoom };
#pragma option pop

#pragma option push -b-
enum TiPlotTickType { ipttMajor, ipttMinor };
#pragma option pop

#pragma option push -b-
enum TiPlotGridLineStyle { ipglsSolid, ipglsDash, ipglsDot };
#pragma option pop

#pragma option push -b-
enum TiPlotCartesianStyle { ipcsNone, ipcsMaster, ipcsChild };
#pragma option pop

class DELPHICLASS TiPlotTickObject;
class PASCALIMPLEMENTATION TiPlotTickObject : public System::TObject 
{
	typedef System::TObject inherited;
	
public:
	TiPlotTickType TickType;
	double Position;
	int PositionPixels;
	AnsiString Text;
	bool Show;
public:
	#pragma option push -w-inl
	/* TObject.Create */ inline __fastcall TiPlotTickObject(void) : System::TObject() { }
	#pragma option pop
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~TiPlotTickObject(void) { }
	#pragma option pop
	
};


class DELPHICLASS TiPlotAxis;
class PASCALIMPLEMENTATION TiPlotAxis : public Qiplotobjects::TiPlotLayoutObject 
{
	typedef Qiplotobjects::TiPlotLayoutObject inherited;
	
private:
	int FActualStart;
	int FActualStop;
	double FPixelsPerSpanUnit;
	TiPlotAxis* FCartesianRefAxis;
	TiPlotAxis* FAlignRefAxis;
	bool FBlockMinSpanEvent;
	Classes::TStringList* FTickList;
	TiQuadSide FQuadSide;
	bool FMouseDown;
	int FMouseDownX;
	int FMouseDownY;
	bool FFirstAlignDone;
	#pragma pack(push, 1)
	Types::TRect FScaleRect;
	#pragma pack(pop)
	
	#pragma pack(push, 1)
	Types::TRect FFocusRect;
	#pragma pack(pop)
	
	int FRequiredWidth;
	int FTitleOffset;
	double FPreviousMin;
	double FPreviousSpan;
	double FPreviousLabelsMinLength;
	bool FAllowLabelMinAdjust;
	double FSpan;
	double FMin;
	bool FReverseScale;
	int FInnerMargin;
	int FOuterMargin;
	double FStackingEndsMargin;
	int FMinorLength;
	int FMajorLength;
	int FMinorCount;
	bool FLabelsVisible;
	double FLabelsMargin;
	int FLabelsPrecision;
	Qitypes::TiPrecisionStyle FLabelsPrecisionStyle;
	Qgraphics::TFont* FLabelsFont;
	double FLabelsMinLength;
	bool FLabelsMinLengthAutoAdjust;
	double FLabelSeparation;
	double FTitleMargin;
	Qgraphics::TFont* FTitleFont;
	bool FTitleShow;
	AnsiString FTitle;
	bool FScaleLineShow;
	Qgraphics::TColor FScaleLinesColor;
	bool FTrackingEnabled;
	TiPlotTrackingStyle FTrackingStyle;
	double FTrackingScrollCompressMax;
	TiPlotAlignFirstStyle FTrackingAlignFirstStyle;
	TiPlotScaleType FScaleType;
	AnsiString FDateTimeFormat;
	TiPlotTextFormat FLabelsFormatStyle;
	TiPlotAxisMode FMode;
	double FDesiredIncrement;
	double FCursorScaler;
	bool FRestoreValuesOnResume;
	double FScrollMin;
	double FScrollMax;
	bool FScrollMinMaxEnabled;
	bool FMasterUIInput;
	double FDesiredStart;
	bool FMonthModeEnabled;
	bool FYearModeEnabled;
	TiPlotCartesianStyle FCartesianStyle;
	double FCartesianChildRefValue;
	AnsiString FCartesianChildRefAxisName;
	bool FGridLinesVisible;
	bool FScaleLinesShow;
	bool FCursorUseDefaultFormat;
	AnsiString FCursorDateTimeFormat;
	TiPlotTextFormat FCursorFormatStyle;
	Qitypes::TiPrecisionStyle FCursorPrecisionStyle;
	int FCursorPrecision;
	bool FCursorMinLengthAutoAdjust;
	double FCursorMinLength;
	bool FLegendUseDefaultFormat;
	TiPlotTextFormat FLegendFormatStyle;
	AnsiString FLegendDateTimeFormat;
	Qitypes::TiPrecisionStyle FLegendPrecisionStyle;
	int FLegendPrecision;
	double FLegendMinLength;
	bool FLegendMinLengthAutoAdjust;
	bool FTickListCustom;
	AnsiString FAlignRefAxisName;
	double __fastcall GetMax(void);
	void __fastcall SetSpan(const double Value);
	void __fastcall SetMin(const double Value);
	void __fastcall SetReverseScale(const bool Value);
	void __fastcall SetInnerMargin(const int Value);
	void __fastcall SetOuterMargin(const int Value);
	void __fastcall SetStackingEndsMargin(const double Value);
	void __fastcall SetLabelsVisible(const bool Value);
	void __fastcall SetLabelsPrecisionStyle(const Qitypes::TiPrecisionStyle Value);
	void __fastcall SetLabelsFont(const Qgraphics::TFont* Value);
	void __fastcall SetLabelsMargin(const double Value);
	void __fastcall SetLabelsPrecision(const int Value);
	void __fastcall SetLabelsMinLength(const double Value);
	void __fastcall SetLabelsMinLengthAutoAdjust(const bool Value);
	void __fastcall SetLabelsFormatStyle(const TiPlotTextFormat Value);
	void __fastcall SetMajorLength(const int Value);
	void __fastcall SetMinorLength(const int Value);
	void __fastcall SetMinorCount(const int Value);
	void __fastcall SetTitleFont(const Qgraphics::TFont* Value);
	void __fastcall SetTitleMargin(const double Value);
	void __fastcall SetTitleShow(const bool Value);
	void __fastcall SetTitle(const AnsiString Value);
	void __fastcall SetScaleLineShow(const bool Value);
	void __fastcall SetScaleLinesShow(const bool Value);
	void __fastcall SetLabelSeparation(const double Value);
	void __fastcall SetScaleLinesColor(const Qgraphics::TColor Value);
	void __fastcall SetTrackingEnabled(const bool Value);
	void __fastcall SetTrackingStyle(const TiPlotTrackingStyle Value);
	void __fastcall SetTrackingScrollCompressMax(const double Value);
	void __fastcall SetTrackingAlignFirstStyle(const TiPlotAlignFirstStyle Value);
	void __fastcall SetScaleType(const TiPlotScaleType Value);
	void __fastcall SetDateTimeFormat(const AnsiString Value);
	void __fastcall SetMode(const TiPlotAxisMode Value);
	void __fastcall SetDesiredIncrement(const double Value);
	void __fastcall SetCursorScaler(const double Value);
	void __fastcall SetRestoreValuesOnResume(const bool Value);
	void __fastcall SetScrollMax(const double Value);
	void __fastcall SetScrollMin(const double Value);
	void __fastcall SetScrollMinMaxEnabled(const bool Value);
	void __fastcall SetMasterUIInput(const bool Value);
	void __fastcall SetDesiredStart(const double Value);
	void __fastcall SetCartesianStyle(const TiPlotCartesianStyle Value);
	void __fastcall SetCartesianChildRefAxisName(const AnsiString Value);
	void __fastcall SetCartesianChildRefValue(const double Value);
	void __fastcall SetAlignRefAxisName(const AnsiString Value);
	void __fastcall SetGridLinesVisible(const bool Value);
	void __fastcall SetCursorDateTimeFormat(const AnsiString Value);
	void __fastcall SetCursorFormatStyle(const TiPlotTextFormat Value);
	void __fastcall SetCursorPrecisionStyle(const Qitypes::TiPrecisionStyle Value);
	void __fastcall SetCursorPrecision(const int Value);
	void __fastcall SetCursorUseDefaultFormat(const bool Value);
	void __fastcall SetCursorMinLength(const double Value);
	void __fastcall SetCursorMinLengthAutoAdjust(const bool Value);
	void __fastcall SetLegendUseDefaultFormat(const bool Value);
	void __fastcall SetLegendFormatStyle(const TiPlotTextFormat Value);
	void __fastcall SetLegendDateTimeFormat(const AnsiString Value);
	void __fastcall SetLegendPrecisionStyle(const Qitypes::TiPrecisionStyle Value);
	void __fastcall SetLegendPrecision(const int Value);
	void __fastcall SetLegendMinLength(const double Value);
	void __fastcall SetLegendMinLengthAutoAdjust(const bool Value);
	void __fastcall SetTickListCustom(const bool Value);
	int __fastcall GetMinPixels(void);
	int __fastcall GetMaxPixels(void);
	int __fastcall GetTickListCount(void);
	TiPlotAxis* __fastcall GetCartesianRefAxis(void);
	TiPlotAxis* __fastcall GetAlignRefAxis(void);
	int __fastcall TickDiv(int Count, int Divisor);
	AnsiString __fastcall GetLabelTextAdjust(const double Value);
	AnsiString __fastcall GetTickListItemLabel(int Index);
	double __fastcall GetTickListItemPosition(int Index);
	TiPlotTickType __fastcall GetTickListItemStyle(int Index);
	void __fastcall SetTickListItemLabel(int Index, const AnsiString Value);
	void __fastcall SetTickListItemPosition(int Index, const double Value);
	void __fastcall SetTickListItemStyle(int Index, const TiPlotTickType Value);
	TiPlotTickObject* __fastcall GetTickObject(int Index);
	
protected:
	virtual void __fastcall DefineProperties(Classes::TFiler* Filer);
	void __fastcall WriteSpan(Classes::TWriter* Writer);
	void __fastcall ReadSpan(Classes::TReader* Reader);
	void __fastcall WriteLabelSeperation(Classes::TWriter* Writer);
	void __fastcall ReadLabelSeperation(Classes::TReader* Reader);
	void __fastcall WriteTitleMargin(Classes::TWriter* Writer);
	void __fastcall ReadTitleMargin(Classes::TReader* Reader);
	virtual void __fastcall NotificationSetFocus(System::TObject* Sender);
	virtual void __fastcall NotificationRemove(System::TObject* Sender);
	virtual void __fastcall NotificationRename(System::TObject* Sender);
	void __fastcall TrackingEnabledMenuItemClick(System::TObject* Sender);
	void __fastcall UpdateResumeValuesMenuItemClick(System::TObject* Sender);
	void __fastcall ZoomToFitClick(System::TObject* Sender);
	void __fastcall CalcTicks(const Qgraphics::TCanvas* Canvas);
	void __fastcall CalcTickPixels(void);
	void __fastcall ClearTickList(void);
	void __fastcall CalcScaleRect(const Qgraphics::TCanvas* Canvas);
	void __fastcall CalcLinearTicks(const Qgraphics::TCanvas* Canvas, int MaxMajorTicks, int &MajorCount, double &MajorStepValue);
	void __fastcall CalcPrice32Ticks(const Qgraphics::TCanvas* Canvas, int MaxMajorTicks, int &MajorCount, double &MajorStepValue);
	void __fastcall CalcDateTimeTicks(const Qgraphics::TCanvas* Canvas, int MaxMajorTicks, int &MajorCount, double &MajorStepValue);
	void __fastcall CalcLog10Ticks(const Qgraphics::TCanvas* Canvas, int MaxMajorTicks);
	void __fastcall AddTick(double Value, TiPlotTickType Style);
	int __fastcall GetSpanLength(void);
	virtual Qcontrols::TCursor __fastcall GetMousePointer(const Types::TPoint &APoint);
	TiPlotAxisMode __fastcall GetActualMode(void);
	bool __fastcall PointOnScale(double Value);
	virtual void __fastcall Draw(const Qgraphics::TCanvas* Canvas, const Qgraphics::TColor BackGroundColor);
	virtual void __fastcall DrawSetup(const Qgraphics::TCanvas* Canvas);
	void __fastcall DrawLines(const Qgraphics::TCanvas* Canvas, const Qgraphics::TColor BackGroundColor);
	void __fastcall DrawScaleLine(Qgraphics::TCanvas* Canvas);
	void __fastcall DrawTitle(Qgraphics::TCanvas* Canvas);
	void __fastcall DrawScaleMajorTick(Qgraphics::TCanvas* Canvas, TiPlotTickObject* iPlotTickObject);
	void __fastcall DrawScaleMinorTick(Qgraphics::TCanvas* Canvas, TiPlotTickObject* iPlotTickObject);
	void __fastcall DrawScaleTick(Qgraphics::TCanvas* Canvas, int PositionPixels, int StartOffset, int StopOffset);
	void __fastcall DrawScaleLabel(Qgraphics::TCanvas* Canvas, TiPlotTickObject* iPlotTickObject);
	void __fastcall DrawGridLines(Qgraphics::TCanvas* Canvas, const Types::TRect &ARect, bool ShowMajors, bool ShowMinors, TiPlotGridLineStyle MajorStyle, TiPlotGridLineStyle MinorStyle, Qgraphics::TColor MajorColor, Qgraphics::TColor MinorColor, int MajorWidth, int MinorWidth);
	virtual void __fastcall AddMenuItems(Qmenus::TPopupMenu* PopupMenu);
	virtual void __fastcall DoMouseHint(const Qiplotobjects::TiPlotMouseData &MouseData, Qiplotobjects::TiHintData &HintData);
	virtual void __fastcall DoMouseLeft(const Qiplotobjects::TiPlotMouseData &MouseData);
	virtual void __fastcall DoMouseMove(const Qiplotobjects::TiPlotMouseData &MouseData);
	virtual void __fastcall DoMouseUp(const Qiplotobjects::TiPlotMouseData &MouseData);
	virtual void __fastcall iKeyDown(Word &CharCode, Classes::TShiftState Shift);
	virtual bool __fastcall iMouseWheel(int WheelDelta, Classes::TShiftState Shift, const Types::TPoint &MousePos);
	virtual bool __fastcall iMouseHitTest(const Qiplotobjects::TiPlotMouseData &MouseData);
	int __fastcall GetMaxLabelLengthPixels(const Qgraphics::TCanvas* Canvas);
	virtual int __fastcall GetRequiredWidth(const Qgraphics::TCanvas* Canvas);
	virtual int __fastcall GetRequiredLengthGaurd(const Qgraphics::TCanvas* Canvas);
	int __fastcall GetRequiredLabelLength(const Qgraphics::TCanvas* Canvas, Qgraphics::TFont* AFont);
	int __fastcall GetRequiredLegendLength(const Qgraphics::TCanvas* Canvas, Qgraphics::TFont* AFont);
	int __fastcall GetRequiredCursorLength(const Qgraphics::TCanvas* Canvas, Qgraphics::TFont* AFont);
	double __fastcall PixelsToPositionDouble(double Value);
	void __fastcall ZoomRect(const Types::TRect &ARect);
	void __fastcall ScrollPercentByReference(double RefMin, double RefSpan, double RefMax, double Percent);
	void __fastcall ZoomPercentByReference(double RefMin, double RefSpan, double RefMax, double Percent);
	__property Types::TRect ScaleRect = {read=FScaleRect};
	__property Types::TRect FocusRect = {read=FFocusRect};
	__property TiPlotAxis* CartesianRefAxis = {read=GetCartesianRefAxis};
	__property TiPlotAxis* AlignRefAxis = {read=GetAlignRefAxis};
	__property TiPlotTickObject* TickObject[int Index] = {read=GetTickObject};
	AnsiString __fastcall GetText(const double Value, const TiPlotTextFormat FormatStyle, const AnsiString DateTimeFormat, const Qitypes::TiPrecisionStyle PrecisionStyle, const int Precision, const bool MinLengthAutoAdjust, double &MinLength);
	
public:
	__fastcall virtual TiPlotAxis(Qcontrols::TWidgetControl* AOwner, Classes::TNotifyEvent AOnChange, Classes::TNotifyEvent AOnInsert, Classes::TNotifyEvent AOnRemove, Classes::TNotifyEvent AOnRename);
	__fastcall virtual ~TiPlotAxis(void);
	AnsiString __fastcall GetLabelText(const double Value);
	AnsiString __fastcall GetCursorText(const double Value);
	AnsiString __fastcall GetLegendText(const double Value);
	void __fastcall SetMinSpan(const double NewMin, const double NewSpan);
	void __fastcall NewTrackingData(double Value);
	void __fastcall ResetFirstAlign(void);
	void __fastcall UpdateResumeValues(void);
	void __fastcall Zoom(double Value);
	void __fastcall ZoomToFit(void);
	void __fastcall TickListClear(void);
	int __fastcall TickListAdd(double Position, AnsiString ALabel, TiPlotTickType Style);
	__property bool TickListCustom = {read=FTickListCustom, write=SetTickListCustom, nodefault};
	__property int TickListCount = {read=GetTickListCount, nodefault};
	__property AnsiString TickListItemLabel[int Index] = {read=GetTickListItemLabel, write=SetTickListItemLabel};
	__property double TickListItemPosition[int Index] = {read=GetTickListItemPosition, write=SetTickListItemPosition};
	__property TiPlotTickType TickListItemStyle[int Index] = {read=GetTickListItemStyle, write=SetTickListItemStyle};
	int __fastcall PositionToPixels(const double Value);
	int __fastcall WidthToPixels(const double Value);
	double __fastcall PixelsToPosition(const int Value);
	double __fastcall PercentToPosition(const double Value);
	double __fastcall PositionToPercent(const double Value);
	bool __fastcall ValueOnScale(const double Value);
	__property int MinPixels = {read=GetMinPixels, nodefault};
	__property int MaxPixels = {read=GetMaxPixels, nodefault};
	__property TiPlotAxisMode Mode = {read=FMode, write=SetMode, nodefault};
	
__published:
	__property double Min = {read=FMin, write=SetMin};
	__property double Span = {read=FSpan, write=SetSpan};
	__property double DesiredStart = {read=FDesiredStart, write=SetDesiredStart};
	__property double DesiredIncrement = {read=FDesiredIncrement, write=SetDesiredIncrement};
	__property double Max = {read=GetMax};
	__property bool ReverseScale = {read=FReverseScale, write=SetReverseScale, default=0};
	__property int InnerMargin = {read=FInnerMargin, write=SetInnerMargin, default=5};
	__property int OuterMargin = {read=FOuterMargin, write=SetOuterMargin, default=5};
	__property AnsiString Title = {read=FTitle, write=SetTitle};
	__property double TitleMargin = {read=FTitleMargin, write=SetTitleMargin};
	__property Qgraphics::TFont* TitleFont = {read=FTitleFont, write=SetTitleFont};
	__property bool TitleShow = {read=FTitleShow, write=SetTitleShow, default=0};
	__property int MajorLength = {read=FMajorLength, write=SetMajorLength, default=7};
	__property int MinorLength = {read=FMinorLength, write=SetMinorLength, default=3};
	__property int MinorCount = {read=FMinorCount, write=SetMinorCount, default=1};
	__property bool LabelsVisible = {read=FLabelsVisible, write=SetLabelsVisible, default=1};
	__property double LabelsMargin = {read=FLabelsMargin, write=SetLabelsMargin};
	__property Qgraphics::TFont* LabelsFont = {read=FLabelsFont, write=SetLabelsFont};
	__property double LabelSeparation = {read=FLabelSeparation, write=SetLabelSeparation};
	__property int LabelsPrecision = {read=FLabelsPrecision, write=SetLabelsPrecision, default=3};
	__property Qitypes::TiPrecisionStyle LabelsPrecisionStyle = {read=FLabelsPrecisionStyle, write=SetLabelsPrecisionStyle, default=0};
	__property TiPlotTextFormat LabelsFormatStyle = {read=FLabelsFormatStyle, write=SetLabelsFormatStyle, default=0};
	__property AnsiString DateTimeFormat = {read=FDateTimeFormat, write=SetDateTimeFormat};
	__property double LabelsMinLength = {read=FLabelsMinLength, write=SetLabelsMinLength};
	__property bool LabelsMinLengthAutoAdjust = {read=FLabelsMinLengthAutoAdjust, write=SetLabelsMinLengthAutoAdjust, default=0};
	__property bool ScaleLineShow = {read=FScaleLineShow, write=SetScaleLineShow, nodefault};
	__property bool ScaleLinesShow = {read=FScaleLinesShow, write=SetScaleLinesShow, default=1};
	__property Qgraphics::TColor ScaleLinesColor = {read=FScaleLinesColor, write=SetScaleLinesColor, default=16777215};
	__property double StackingEndsMargin = {read=FStackingEndsMargin, write=SetStackingEndsMargin};
	__property TiPlotScaleType ScaleType = {read=FScaleType, write=SetScaleType, default=0};
	__property bool TrackingEnabled = {read=FTrackingEnabled, write=SetTrackingEnabled, default=1};
	__property TiPlotTrackingStyle TrackingStyle = {read=FTrackingStyle, write=SetTrackingStyle, nodefault};
	__property TiPlotAlignFirstStyle TrackingAlignFirstStyle = {read=FTrackingAlignFirstStyle, write=SetTrackingAlignFirstStyle, default=0};
	__property double TrackingScrollCompressMax = {read=FTrackingScrollCompressMax, write=SetTrackingScrollCompressMax};
	__property bool CursorUseDefaultFormat = {read=FCursorUseDefaultFormat, write=SetCursorUseDefaultFormat, default=1};
	__property TiPlotTextFormat CursorFormatStyle = {read=FCursorFormatStyle, write=SetCursorFormatStyle, default=0};
	__property AnsiString CursorDateTimeFormat = {read=FCursorDateTimeFormat, write=SetCursorDateTimeFormat};
	__property Qitypes::TiPrecisionStyle CursorPrecisionStyle = {read=FCursorPrecisionStyle, write=SetCursorPrecisionStyle, default=0};
	__property int CursorPrecision = {read=FCursorPrecision, write=SetCursorPrecision, nodefault};
	__property double CursorMinLength = {read=FCursorMinLength, write=SetCursorMinLength};
	__property bool CursorMinLengthAutoAdjust = {read=FCursorMinLengthAutoAdjust, write=SetCursorMinLengthAutoAdjust, default=0};
	__property bool LegendUseDefaultFormat = {read=FLegendUseDefaultFormat, write=SetLegendUseDefaultFormat, default=1};
	__property TiPlotTextFormat LegendFormatStyle = {read=FLegendFormatStyle, write=SetLegendFormatStyle, default=0};
	__property AnsiString LegendDateTimeFormat = {read=FLegendDateTimeFormat, write=SetLegendDateTimeFormat};
	__property Qitypes::TiPrecisionStyle LegendPrecisionStyle = {read=FLegendPrecisionStyle, write=SetLegendPrecisionStyle, default=0};
	__property int LegendPrecision = {read=FLegendPrecision, write=SetLegendPrecision, nodefault};
	__property double LegendMinLength = {read=FLegendMinLength, write=SetLegendMinLength};
	__property bool LegendMinLengthAutoAdjust = {read=FLegendMinLengthAutoAdjust, write=SetLegendMinLengthAutoAdjust, default=0};
	__property double CursorScaler = {read=FCursorScaler, write=SetCursorScaler};
	__property bool ScrollMinMaxEnabled = {read=FScrollMinMaxEnabled, write=SetScrollMinMaxEnabled, nodefault};
	__property double ScrollMax = {read=FScrollMax, write=SetScrollMax};
	__property double ScrollMin = {read=FScrollMin, write=SetScrollMin};
	__property bool RestoreValuesOnResume = {read=FRestoreValuesOnResume, write=SetRestoreValuesOnResume, nodefault};
	__property bool MasterUIInput = {read=FMasterUIInput, write=SetMasterUIInput, nodefault};
	__property TiPlotCartesianStyle CartesianStyle = {read=FCartesianStyle, write=SetCartesianStyle, nodefault};
	__property AnsiString CartesianChildRefAxisName = {read=FCartesianChildRefAxisName, write=SetCartesianChildRefAxisName};
	__property double CartesianChildRefValue = {read=FCartesianChildRefValue, write=SetCartesianChildRefValue};
	__property AnsiString AlignRefAxisName = {read=FAlignRefAxisName, write=SetAlignRefAxisName};
	__property bool GridLinesVisible = {read=FGridLinesVisible, write=SetGridLinesVisible, nodefault};
	__property ForceStacking ;
};


class DELPHICLASS TiPlotXAxis;
class PASCALIMPLEMENTATION TiPlotXAxis : public TiPlotAxis 
{
	typedef TiPlotAxis inherited;
	
public:
	__fastcall virtual TiPlotXAxis(Qcontrols::TWidgetControl* AOwner, Classes::TNotifyEvent AOnChange, Classes::TNotifyEvent AOnInsert, Classes::TNotifyEvent AOnRemove, Classes::TNotifyEvent AOnRename);
public:
	#pragma option push -w-inl
	/* TiPlotAxis.Destroy */ inline __fastcall virtual ~TiPlotXAxis(void) { }
	#pragma option pop
	
};


class DELPHICLASS TiPlotYAxis;
class PASCALIMPLEMENTATION TiPlotYAxis : public TiPlotAxis 
{
	typedef TiPlotAxis inherited;
	
public:
	__fastcall virtual TiPlotYAxis(Qcontrols::TWidgetControl* AOwner, Classes::TNotifyEvent AOnChange, Classes::TNotifyEvent AOnInsert, Classes::TNotifyEvent AOnRemove, Classes::TNotifyEvent AOnRename);
public:
	#pragma option push -w-inl
	/* TiPlotAxis.Destroy */ inline __fastcall virtual ~TiPlotYAxis(void) { }
	#pragma option pop
	
};


//-- var, const, procedure ---------------------------------------------------
static const Extended TIME_HOUR = 4.166667E-02;
static const Extended TIME_MINUTE = 6.944444E-04;
static const Extended TIME_SECOND = 1.157407E-05;
static const Extended TIME_MILLISECOND = 1.157407E-08;

}	/* namespace Qiplotaxis */
using namespace Qiplotaxis;
#pragma option pop	// -w-
#pragma option pop	// -Vx

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// QiPlotAxis
