// Borland C++ Builder
// Copyright (c) 1995, 2002 by Borland Software Corporation
// All rights reserved

// (DO NOT EDIT: machine generated header) 'QiLedMatrix.pas' rev: 6.00

#ifndef QiLedMatrixHPP
#define QiLedMatrixHPP

#pragma delphiheader begin
#pragma option push -w-
#pragma option push -Vx
#include <QiComponent.hpp>	// Pascal unit
#include <QiCLXComponent.hpp>	// Pascal unit
#include <QiCustomComponent.hpp>	// Pascal unit
#include <QiGPFunctions.hpp>	// Pascal unit
#include <QiTypes.hpp>	// Pascal unit
#include <QExtCtrls.hpp>	// Pascal unit
#include <QStdCtrls.hpp>	// Pascal unit
#include <QComCtrls.hpp>	// Pascal unit
#include <QControls.hpp>	// Pascal unit
#include <Variants.hpp>	// Pascal unit
#include <Classes.hpp>	// Pascal unit
#include <Types.hpp>	// Pascal unit
#include <QTypes.hpp>	// Pascal unit
#include <QClipbrd.hpp>	// Pascal unit
#include <QDialogs.hpp>	// Pascal unit
#include <QForms.hpp>	// Pascal unit
#include <QGraphics.hpp>	// Pascal unit
#include <Qt.hpp>	// Pascal unit
#include <TypInfo.hpp>	// Pascal unit
#include <Libc.hpp>	// Pascal unit
#include <SysUtils.hpp>	// Pascal unit
#include <Xlib.hpp>	// Pascal unit
#include <SysInit.hpp>	// Pascal unit
#include <System.hpp>	// Pascal unit

//-- user supplied -----------------------------------------------------------

namespace Qiledmatrix
{
//-- type declarations -------------------------------------------------------
typedef void __fastcall (__closure *TClickIndicatorEvent)(int Row, int Col);

class DELPHICLASS TLedCacheObject;
class PASCALIMPLEMENTATION TLedCacheObject : public System::TObject 
{
	typedef System::TObject inherited;
	
public:
	Qgraphics::TBitmap* ActiveBitmap;
	Qgraphics::TBitmap* InActiveBitmap;
	Qgraphics::TColor Color;
	__fastcall virtual ~TLedCacheObject(void);
public:
	#pragma option push -w-inl
	/* TObject.Create */ inline __fastcall TLedCacheObject(void) : System::TObject() { }
	#pragma option pop
	
};


class DELPHICLASS TLedCache;
class PASCALIMPLEMENTATION TLedCache : public System::TObject 
{
	typedef System::TObject inherited;
	
private:
	Classes::TList* FCacheList;
	
public:
	__fastcall TLedCache(void);
	__fastcall virtual ~TLedCache(void);
	TLedCacheObject* __fastcall Find(Qgraphics::TColor AColor);
	void __fastcall Add(TLedCacheObject* LedCacheObject);
	void __fastcall Clear(void);
};


#pragma pack(push, 4)
struct TIndicatorData
{
	Qgraphics::TColor Color;
	System::SmallString<50>  Caption;
	bool Active;
	bool Dirty;
	Types::TRect ARect;
	bool MouseDown;
} ;
#pragma pack(pop)

typedef TIndicatorData TIndicatorList[100001];

typedef TIndicatorData *PIndicatorList;

#pragma option push -b-
enum TiLedMatrixIndiatorStyle { ilmisRound, ilmisRectangle };
#pragma option pop

class DELPHICLASS TiLedMatrix;
class PASCALIMPLEMENTATION TiLedMatrix : public Qicustomcomponent::TiCustomComponent 
{
	typedef Qicustomcomponent::TiCustomComponent inherited;
	
private:
	TLedCache* FLedCache;
	bool FFillBackGround;
	TIndicatorData *FIndicatorList;
	Qgraphics::TColor FIndicatorActiveColor;
	int FColCount;
	int FRowCount;
	TiLedMatrixIndiatorStyle FIndicatorStyle;
	int FIndicatorHeight;
	int FIndicatorWidth;
	Qitypes::TiBevelStyle FIndicatorBevelStyle;
	int FSpacingHorizontal;
	int FOuterMargin;
	int FSpacingVertical;
	bool FAutoSize;
	Classes::TNotifyEvent FOnAutoSize;
	Qgraphics::TFont* FIndicatorCaptionInactiveFont;
	Qgraphics::TFont* FIndicatorCaptionActiveFont;
	bool FIndicatorShowReflection;
	bool FDoingAutoSize;
	TClickIndicatorEvent FOnMouseUpIndicator;
	TClickIndicatorEvent FOnMouseMoveIndicator;
	TClickIndicatorEvent FOnMouseDownIndicator;
	TClickIndicatorEvent FOnClickIndicator;
	TClickIndicatorEvent FOnDblClickIndicator;
	int FClickRow;
	int FClickCol;
	void __fastcall SetIndicatorActiveColor(const Qgraphics::TColor Value);
	void __fastcall SetColCount(const int Value);
	void __fastcall SetRowCount(const int Value);
	void __fastcall SetIndicatorStyle(const TiLedMatrixIndiatorStyle Value);
	void __fastcall SetIndicatorBevelStyle(const Qitypes::TiBevelStyle Value);
	void __fastcall SetIndicatorHeight(const int Value);
	void __fastcall SetIndicatorWidth(const int Value);
	void __fastcall SetOuterMargin(const int Value);
	void __fastcall SetSpacingHorizontal(const int Value);
	void __fastcall SetSpacingVertical(const int Value);
	void __fastcall iSetAutoSize(const bool Value);
	void __fastcall SetIndicatorActive(int Row, int Col, const bool Value);
	void __fastcall SetIndicatorColor(int Row, int Col, const Qgraphics::TColor Value);
	bool __fastcall GetIndicatorActive(int Row, int Col);
	Qgraphics::TColor __fastcall GetIndicatorColor(int Row, int Col);
	AnsiString __fastcall GetIndicatorCaption(int Row, int Col);
	void __fastcall SetIndicatorCaption(int Row, int Col, const AnsiString Value);
	void __fastcall SetIndicatorCaptionActiveFont(const Qgraphics::TFont* Value);
	void __fastcall SetIndicatorCaptionInactiveFont(const Qgraphics::TFont* Value);
	void __fastcall SetIndicatorShowReflection(const bool Value);
	
protected:
	Types::TPoint __fastcall GetAutoSize(void);
	int __fastcall GetLedAtXY(int X, int Y);
	virtual void __fastcall SetTransparent(const bool Value);
	virtual void __fastcall SetBackGroundColor(const Qgraphics::TColor Value);
	virtual void __fastcall SetBorderStyle(const Qitypes::TiBevelStyle Value);
	virtual void __fastcall SetCachedDrawing(const bool Value);
	void __fastcall DoAutoSize(void);
	void __fastcall SetCapacity(void);
	virtual void __fastcall iPaintTo(Qgraphics::TCanvas* Canvas);
	void __fastcall iPaintCached(Qgraphics::TCanvas* Canvas);
	void __fastcall iPaintNonCached(Qgraphics::TCanvas* Canvas);
	void __fastcall DrawRound(Qgraphics::TCanvas* Canvas, const Types::TRect &DrawRect, bool Active, Qgraphics::TColor AColor);
	void __fastcall DrawRectangle(Qgraphics::TCanvas* Canvas, const Types::TRect &DrawRect, bool Active, Qgraphics::TColor AColor);
	void __fastcall RedoAll(void);
	void __fastcall ClearMouseDown(void);
	virtual void __fastcall iDoKillFocus(void);
	virtual void __fastcall iMouseDown(Qcontrols::TMouseButton Button, Classes::TShiftState Shift, int X, int Y);
	virtual void __fastcall iMouseMove(Classes::TShiftState Shift, int X, int Y);
	virtual void __fastcall iMouseUp(Qcontrols::TMouseButton Button, Classes::TShiftState Shift, int X, int Y);
	DYNAMIC void __fastcall DblClick(void);
	
public:
	__fastcall virtual TiLedMatrix(Classes::TComponent* AOwner);
	__fastcall virtual ~TiLedMatrix(void);
	virtual void __fastcall SetBounds(int ALeft, int ATop, int AWidth, int AHeight);
	__property bool IndicatorActive[int Row][int Col] = {read=GetIndicatorActive, write=SetIndicatorActive};
	__property Qgraphics::TColor IndicatorColor[int Row][int Col] = {read=GetIndicatorColor, write=SetIndicatorColor};
	__property AnsiString IndicatorCaption[int Row][int Col] = {read=GetIndicatorCaption, write=SetIndicatorCaption};
	__property Classes::TNotifyEvent OnAutoSize = {read=FOnAutoSize, write=FOnAutoSize};
	
__published:
	__property bool AutoSize = {read=FAutoSize, write=iSetAutoSize, default=1};
	__property Qgraphics::TColor IndicatorActiveColor = {read=FIndicatorActiveColor, write=SetIndicatorActiveColor, default=65280};
	__property int ColCount = {read=FColCount, write=SetColCount, default=5};
	__property int RowCount = {read=FRowCount, write=SetRowCount, default=5};
	__property TiLedMatrixIndiatorStyle IndicatorStyle = {read=FIndicatorStyle, write=SetIndicatorStyle, default=1};
	__property int IndicatorWidth = {read=FIndicatorWidth, write=SetIndicatorWidth, default=10};
	__property int IndicatorHeight = {read=FIndicatorHeight, write=SetIndicatorHeight, default=10};
	__property Qitypes::TiBevelStyle IndicatorBevelStyle = {read=FIndicatorBevelStyle, write=SetIndicatorBevelStyle, default=0};
	__property Qgraphics::TFont* IndicatorCaptionActiveFont = {read=FIndicatorCaptionActiveFont, write=SetIndicatorCaptionActiveFont};
	__property Qgraphics::TFont* IndicatorCaptionInactiveFont = {read=FIndicatorCaptionInactiveFont, write=SetIndicatorCaptionInactiveFont};
	__property int OuterMargin = {read=FOuterMargin, write=SetOuterMargin, default=5};
	__property int SpacingHorizontal = {read=FSpacingHorizontal, write=SetSpacingHorizontal, default=2};
	__property int SpacingVertical = {read=FSpacingVertical, write=SetSpacingVertical, default=2};
	__property bool IndicatorShowReflection = {read=FIndicatorShowReflection, write=SetIndicatorShowReflection, default=1};
	__property TClickIndicatorEvent OnMouseDownIndicator = {read=FOnMouseDownIndicator, write=FOnMouseDownIndicator};
	__property TClickIndicatorEvent OnMouseMoveIndicator = {read=FOnMouseMoveIndicator, write=FOnMouseMoveIndicator};
	__property TClickIndicatorEvent OnMouseUpIndicator = {read=FOnMouseUpIndicator, write=FOnMouseUpIndicator};
	__property TClickIndicatorEvent OnClickIndicator = {read=FOnClickIndicator, write=FOnClickIndicator};
	__property TClickIndicatorEvent OnDblClickIndicator = {read=FOnDblClickIndicator, write=FOnDblClickIndicator};
	__property BackGroundColor  = {default=-2};
	__property BorderStyle  = {default=0};
	__property Transparent  = {default=0};
	__property CachedDrawing  = {default=1};
	__property Width  = {default=150};
	__property Height  = {default=150};
public:
	#pragma option push -w-inl
	/* TWidgetControl.CreateParented */ inline __fastcall TiLedMatrix(Qt::QWidgetH* ParentWidget) : Qicustomcomponent::TiCustomComponent(ParentWidget) { }
	#pragma option pop
	
};


//-- var, const, procedure ---------------------------------------------------

}	/* namespace Qiledmatrix */
using namespace Qiledmatrix;
#pragma option pop	// -w-
#pragma option pop	// -Vx

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// QiLedMatrix
