// Borland C++ Builder
// Copyright (c) 1995, 2002 by Borland Software Corporation
// All rights reserved

// (DO NOT EDIT: machine generated header) 'QiLCDMatrix.pas' rev: 6.00

#ifndef QiLCDMatrixHPP
#define QiLCDMatrixHPP

#pragma delphiheader begin
#pragma option push -w-
#pragma option push -Vx
#include <QiCLXComponent.hpp>	// Pascal unit
#include <QiComponent.hpp>	// Pascal unit
#include <QiLCDCharacter.hpp>	// Pascal unit
#include <QiCustomComponent.hpp>	// Pascal unit
#include <QiMath.hpp>	// Pascal unit
#include <QiGPFunctions.hpp>	// Pascal unit
#include <QiTypes.hpp>	// Pascal unit
#include <QExtCtrls.hpp>	// Pascal unit
#include <QStdCtrls.hpp>	// Pascal unit
#include <QComCtrls.hpp>	// Pascal unit
#include <QControls.hpp>	// Pascal unit
#include <Variants.hpp>	// Pascal unit
#include <Classes.hpp>	// Pascal unit
#include <Types.hpp>	// Pascal unit
#include <QTypes.hpp>	// Pascal unit
#include <QClipbrd.hpp>	// Pascal unit
#include <QDialogs.hpp>	// Pascal unit
#include <QForms.hpp>	// Pascal unit
#include <QGraphics.hpp>	// Pascal unit
#include <Qt.hpp>	// Pascal unit
#include <TypInfo.hpp>	// Pascal unit
#include <Libc.hpp>	// Pascal unit
#include <SysUtils.hpp>	// Pascal unit
#include <Xlib.hpp>	// Pascal unit
#include <SysInit.hpp>	// Pascal unit
#include <System.hpp>	// Pascal unit

//-- user supplied -----------------------------------------------------------

namespace Qilcdmatrix
{
//-- type declarations -------------------------------------------------------
typedef void __fastcall (__closure *TClickCellEvent)(System::TObject* Sender, int Col, int Row);

class DELPHICLASS TiLCDElement;
class PASCALIMPLEMENTATION TiLCDElement : public System::TObject 
{
	typedef System::TObject inherited;
	
public:
	Qgraphics::TColor Color;
	char AChar;
public:
	#pragma option push -w-inl
	/* TObject.Create */ inline __fastcall TiLCDElement(void) : System::TObject() { }
	#pragma option pop
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~TiLCDElement(void) { }
	#pragma option pop
	
};


class DELPHICLASS TiLCDMatrix;
class PASCALIMPLEMENTATION TiLCDMatrix : public Qicustomcomponent::TiCustomComponent 
{
	typedef Qicustomcomponent::TiCustomComponent inherited;
	
private:
	#pragma pack(push, 1)
	Types::TRect FClientRect;
	#pragma pack(pop)
	
	int FBorderMargin;
	AnsiString FText;
	Classes::TStringList* FCharacterList;
	Classes::TStringList* FElementList;
	int FCellsHorz;
	int FCellsVert;
	int FCellsWidth;
	int FCellsSpacingHorz;
	int FCellsSpacingVert;
	Qgraphics::TColor FCellsColorOn;
	Qgraphics::TColor FCellsColorOff;
	bool FCellsShowOff;
	int FCharactersetWidth;
	int FCharactersetHeight;
	AnsiString FCharactersetName;
	int FCharacterSpacingHorz;
	int FCharacterSpacingVert;
	int FCharactersHorz;
	int FCharactersVert;
	int FExtraPixelsHorz;
	int FExtraPixelsVert;
	#pragma pack(push, 1)
	Types::TPoint FDrawStartPoint;
	#pragma pack(pop)
	
	int FOuterMarginTop;
	int FOuterMarginLeft;
	int FOuterMarginRight;
	int FOuterMarginBottom;
	
protected:
	HIDESBASE void __fastcall SetText(const AnsiString Value);
	void __fastcall SetCharactersetWidth(const int Value);
	void __fastcall SetCharactersetHeight(const int Value);
	void __fastcall SetCharactersetName(const AnsiString Value);
	void __fastcall SetCharacterSpacingHorz(const int Value);
	void __fastcall SetCharacterSpacingVert(const int Value);
	void __fastcall SetCellsColorOn(const Qgraphics::TColor Value);
	void __fastcall SetCellsColorOff(const Qgraphics::TColor Value);
	void __fastcall SetCellsSpacingHorz(const int Value);
	void __fastcall SetCellsSpacingVert(const int Value);
	void __fastcall SetCellsWidth(const int Value);
	void __fastcall SetCellsShowOff(const bool Value);
	void __fastcall SetOuterMarginBottom(const int Value);
	void __fastcall SetOuterMarginLeft(const int Value);
	void __fastcall SetOuterMarginRight(const int Value);
	void __fastcall SetOuterMarginTop(const int Value);
	Qgraphics::TColor __fastcall GetElementColor(int Col, int Row);
	char __fastcall GetElementChar(int Col, int Row);
	int __fastcall GetElementCharCode(int Col, int Row);
	void __fastcall SetElementColor(int Col, int Row, const Qgraphics::TColor Value);
	void __fastcall SetElementChar(int Col, int Row, const char Value);
	void __fastcall SetElementCode(int Col, int Row, const int Value);
	void __fastcall AdjustElementList(int RequiredElements);
	virtual void __fastcall DefineProperties(Classes::TFiler* Filer);
	void __fastcall ReadFromStream(Classes::TReader* Reader);
	void __fastcall WriteToStream(Classes::TWriter* Writer);
	Qilcdcharacter::TiLCDCharacter* __fastcall GetCharacterObject(int Index);
	TiLCDElement* __fastcall GetElementObject(int Index);
	virtual void __fastcall iPaintTo(Qgraphics::TCanvas* Canvas);
	void __fastcall DrawCalc(void);
	void __fastcall DrawGrid(Qgraphics::TCanvas* Canvas);
	void __fastcall DrawText(Qgraphics::TCanvas* Canvas);
	void __fastcall DrawCell(Qgraphics::TCanvas* Canvas, int Col, int Row, bool Active);
	void __fastcall DrawCharacter(Qgraphics::TCanvas* Canvas, int Col, int Row, int CharacterIndex, Qgraphics::TColor Color);
	__property Qilcdcharacter::TiLCDCharacter* CharacterObject[int Index] = {read=GetCharacterObject};
	__property TiLCDElement* ElementObject[int Index] = {read=GetElementObject};
	
public:
	__fastcall virtual TiLCDMatrix(Classes::TComponent* AOwner);
	__fastcall virtual ~TiLCDMatrix(void);
	void __fastcall LoadDefaultCharacterset(void);
	void __fastcall BlankAllCharacters(void);
	void __fastcall SetCharactorRowData(int CharacterIndex, int RowIndex, int Value);
	void __fastcall LoadCharactersetFromFile(AnsiString FileName);
	void __fastcall SaveCharactersetToFile(AnsiString FileName);
	void __fastcall Clear(void);
	void __fastcall PlaceText(AnsiString AText, int Col, int Row, Qgraphics::TColor AColor);
	__property Qgraphics::TColor ElementColor[int Col][int Row] = {read=GetElementColor, write=SetElementColor};
	__property char ElementChar[int Col][int Row] = {read=GetElementChar, write=SetElementChar};
	__property int ElementCharCode[int Col][int Row] = {read=GetElementCharCode, write=SetElementCode};
	__property int CharactersHorz = {read=FCharactersHorz, nodefault};
	__property int CharactersVert = {read=FCharactersVert, nodefault};
	
__published:
	__property Width  = {default=300};
	__property Height  = {default=100};
	__property int CharactersetWidth = {read=FCharactersetWidth, write=SetCharactersetWidth, default=5};
	__property int CharactersetHeight = {read=FCharactersetHeight, write=SetCharactersetHeight, default=7};
	__property int CharacterSpacingHorz = {read=FCharacterSpacingHorz, write=SetCharacterSpacingHorz, default=1};
	__property int CharacterSpacingVert = {read=FCharacterSpacingVert, write=SetCharacterSpacingVert, default=1};
	__property Qgraphics::TColor CellsColorOn = {read=FCellsColorOn, write=SetCellsColorOn, default=16776960};
	__property Qgraphics::TColor CellsColorOff = {read=FCellsColorOff, write=SetCellsColorOff, default=8421376};
	__property int CellsSpacingHorz = {read=FCellsSpacingHorz, write=SetCellsSpacingHorz, default=1};
	__property int CellsSpacingVert = {read=FCellsSpacingVert, write=SetCellsSpacingVert, default=1};
	__property int CellsWidth = {read=FCellsWidth, write=SetCellsWidth, default=2};
	__property bool CellsShowOff = {read=FCellsShowOff, write=SetCellsShowOff, nodefault};
	__property AnsiString Text = {read=FText, write=SetText};
	__property int OuterMarginLeft = {read=FOuterMarginLeft, write=SetOuterMarginLeft, default=5};
	__property int OuterMarginTop = {read=FOuterMarginTop, write=SetOuterMarginTop, default=5};
	__property int OuterMarginRight = {read=FOuterMarginRight, write=SetOuterMarginRight, default=5};
	__property int OuterMarginBottom = {read=FOuterMarginBottom, write=SetOuterMarginBottom, default=5};
	__property AnsiString CharactersetName = {read=FCharactersetName};
	__property BackGroundColor  = {default=9671775};
	__property BorderStyle  = {default=1};
	__property Align  = {default=0};
public:
	#pragma option push -w-inl
	/* TWidgetControl.CreateParented */ inline __fastcall TiLCDMatrix(Qt::QWidgetH* ParentWidget) : Qicustomcomponent::TiCustomComponent(ParentWidget) { }
	#pragma option pop
	
};


//-- var, const, procedure ---------------------------------------------------

}	/* namespace Qilcdmatrix */
using namespace Qilcdmatrix;
#pragma option pop	// -w-
#pragma option pop	// -Vx

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// QiLCDMatrix
