// Borland C++ Builder
// Copyright (c) 1995, 2002 by Borland Software Corporation
// All rights reserved

// (DO NOT EDIT: machine generated header) 'QiKeyBoard.pas' rev: 6.00

#ifndef QiKeyBoardHPP
#define QiKeyBoardHPP

#pragma delphiheader begin
#pragma option push -w-
#pragma option push -Vx
#include <QiCLXComponent.hpp>	// Pascal unit
#include <QiComponent.hpp>	// Pascal unit
#include <QiCustomComponent.hpp>	// Pascal unit
#include <QiClasses.hpp>	// Pascal unit
#include <QiGPFunctions.hpp>	// Pascal unit
#include <QiTypes.hpp>	// Pascal unit
#include <QExtCtrls.hpp>	// Pascal unit
#include <QStdCtrls.hpp>	// Pascal unit
#include <QComCtrls.hpp>	// Pascal unit
#include <QControls.hpp>	// Pascal unit
#include <Variants.hpp>	// Pascal unit
#include <Classes.hpp>	// Pascal unit
#include <Types.hpp>	// Pascal unit
#include <QTypes.hpp>	// Pascal unit
#include <QClipbrd.hpp>	// Pascal unit
#include <QDialogs.hpp>	// Pascal unit
#include <QForms.hpp>	// Pascal unit
#include <QGraphics.hpp>	// Pascal unit
#include <Qt.hpp>	// Pascal unit
#include <TypInfo.hpp>	// Pascal unit
#include <Libc.hpp>	// Pascal unit
#include <SysUtils.hpp>	// Pascal unit
#include <Xlib.hpp>	// Pascal unit
#include <SysInit.hpp>	// Pascal unit
#include <System.hpp>	// Pascal unit

//-- user supplied -----------------------------------------------------------

namespace Qikeyboard
{
//-- type declarations -------------------------------------------------------
#pragma option push -b-
enum TiKeyBoardButtonStyle { ikbbsStandard, ikbbsShift, ikbbsLock, ikbbsAccent, ikbbsScroll, ikbbsCtrl, ikbbsAlt, ikbbsNumLock, ikbbsSpacer };
#pragma option pop

#pragma option push -b-
enum TiKeyBoardStyle { ikbs104, ikbs87, ikbs74, ikbs61, ikbsNumericKeyPad };
#pragma option pop

#pragma pack(push, 4)
struct TKeyData
{
	TiKeyBoardButtonStyle Style;
	AnsiString CaptionStandard;
	AnsiString CaptionShift;
	int VirtualKeyCode;
	int Size;
	bool AcceptLock;
} ;
#pragma pack(pop)

class DELPHICLASS TiKeyBoardButton;
class PASCALIMPLEMENTATION TiKeyBoardButton : public Qiclasses::TiButton 
{
	typedef Qiclasses::TiButton inherited;
	
private:
	TiKeyBoardButtonStyle FStyle;
	int FVirtualKeyCode;
	bool FAcceptLock;
	int FRow;
	int FSize;
	bool FDoubleHeight;
	AnsiString FCaptionShift;
	AnsiString FCaptionStandard;
	bool FLockActive;
	bool FShiftActive;
	bool FCtrlActive;
	bool FAltActive;
	bool FShowShift;
	bool FNumLockActive;
	bool FDown;
	int FFocusHandle;
	void __fastcall SetAcceptLock(const bool Value);
	void __fastcall SetCaptionShift(const AnsiString Value);
	void __fastcall SetCaptionStandard(const AnsiString Value);
	void __fastcall SetDoubleHeight(const bool Value);
	void __fastcall SetRow(const int Value);
	void __fastcall SetSize(const int Value);
	void __fastcall SetStyle(const TiKeyBoardButtonStyle Value);
	void __fastcall SetVirtualKeyCode(const int Value);
	
protected:
	AnsiString __fastcall GetDisplayString(void);
	bool __fastcall GetIsToggle(void);
	void __fastcall UpdateKeyState(void);
	
public:
	virtual void __fastcall iMouseDown(Qcontrols::TMouseButton Button, Classes::TShiftState Shift, int X, int Y, int ScreenX, int ScreenY);
	virtual void __fastcall iMouseUp(Qcontrols::TMouseButton Button, Classes::TShiftState Shift, int X, int Y, int ScreenX, int ScreenY);
	virtual void __fastcall Draw(const Qgraphics::TCanvas* Canvas);
	__fastcall virtual TiKeyBoardButton(void);
	__property bool LockActive = {read=FLockActive, write=FLockActive, nodefault};
	__property bool ShiftActive = {read=FShiftActive, write=FShiftActive, nodefault};
	__property bool CtrlActive = {read=FCtrlActive, write=FCtrlActive, nodefault};
	__property bool AltActive = {read=FAltActive, write=FAltActive, nodefault};
	__property bool NumLockActive = {read=FNumLockActive, write=FNumLockActive, nodefault};
	__property AnsiString DisplayString = {read=GetDisplayString};
	__property bool IsToggle = {read=GetIsToggle, nodefault};
	__property bool Down = {read=FDown, write=FDown, nodefault};
	__property int FocusHandle = {read=FFocusHandle, write=FFocusHandle, nodefault};
	
__published:
	__property TiKeyBoardButtonStyle Style = {read=FStyle, write=SetStyle, nodefault};
	__property AnsiString CaptionStandard = {read=FCaptionStandard, write=SetCaptionStandard};
	__property AnsiString CaptionShift = {read=FCaptionShift, write=SetCaptionShift};
	__property bool AcceptLock = {read=FAcceptLock, write=SetAcceptLock, nodefault};
	__property int VirtualKeyCode = {read=FVirtualKeyCode, write=SetVirtualKeyCode, nodefault};
	__property int Row = {read=FRow, write=SetRow, nodefault};
	__property int Size = {read=FSize, write=SetSize, nodefault};
	__property bool DoubleHeight = {read=FDoubleHeight, write=SetDoubleHeight, nodefault};
public:
	#pragma option push -w-inl
	/* TiButton.Destroy */ inline __fastcall virtual ~TiKeyBoardButton(void) { }
	#pragma option pop
	
};


class DELPHICLASS TiKeyBoard;
class PASCALIMPLEMENTATION TiKeyBoard : public Qicustomcomponent::TiCustomComponent 
{
	typedef Qicustomcomponent::TiCustomComponent inherited;
	
private:
	Classes::TStringList* FButtonList;
	Classes::TStringList* FRowListManager;
	Qgraphics::TFont* FFont;
	int FOuterMargin;
	TiKeyBoardButton* FMouseDownObject;
	int FSecondRowMargin;
	TiKeyBoardStyle FStyle;
	int FFocusHandle;
	bool FLockFocusHandle;
	void __fastcall SetFocusHandle(const int Value);
	
protected:
	HIDESBASE void __fastcall SetFont(const Qgraphics::TFont* Value);
	void __fastcall SetOuterMargin(const int Value);
	void __fastcall SetSecondRowMargin(const int Value);
	void __fastcall CalcRects(void);
	TiKeyBoardButton* __fastcall CreateDefaultButton(void);
	void __fastcall CreateSpacer(int Row, int Size);
	TiKeyBoardButton* __fastcall CreateButton(int VirtualKeyCode, int Row, int Size, bool DoubleHeight);
	int __fastcall GetKeyCount(void);
	TiKeyBoardButton* __fastcall GetKeyButton(int Index);
	void __fastcall UnSelectAllOthers(TiKeyBoardButton* Button);
	void __fastcall UnSelectShiftCtrlAlt(void);
	void __fastcall SetLockStatus(bool Value);
	void __fastcall SetShiftStatus(bool Value);
	void __fastcall SetCtrlStatus(bool Value);
	void __fastcall SetAltStatus(bool Value);
	void __fastcall SetNumLockStatus(bool Value);
	HIDESBASE void __fastcall SetStyle(const TiKeyBoardStyle Value);
	void __fastcall ButtonInvalidate(System::TObject* Sender);
	void __fastcall FontChange(System::TObject* Sender);
	void __fastcall ButtonClick(System::TObject* Sender);
	virtual void __fastcall iMouseDown(Qcontrols::TMouseButton Button, Classes::TShiftState Shift, int X, int Y);
	virtual void __fastcall iMouseUp(Qcontrols::TMouseButton Button, Classes::TShiftState Shift, int X, int Y);
	virtual void __fastcall iMouseMove(Classes::TShiftState Shift, int X, int Y);
	int __fastcall GetRowSize(Classes::TStringList* RowList);
	void __fastcall RemoveAllButtons(void);
	void __fastcall RemoveAllRows(void);
	void __fastcall Setup104(void);
	void __fastcall Setup087(void);
	void __fastcall Setup074(void);
	void __fastcall Setup061(void);
	void __fastcall SetupNumericKeyPad(void);
	void __fastcall LoadKeyData(int Index, int VirtualKeyCode, TiKeyBoardButtonStyle Style, AnsiString CaptionStandard, AnsiString CaptionShift, bool AcceptLock);
	void __fastcall LoadKeyDataArray(void);
	virtual void __fastcall iDoKillFocus(void);
	virtual void __fastcall iPaintTo(Qgraphics::TCanvas* Canvas);
	virtual void __fastcall DefineProperties(Classes::TFiler* Filer);
	void __fastcall WriteItems(Classes::TWriter* Writer);
	void __fastcall ReadItems(Classes::TReader* Reader);
	bool __fastcall DoWriteItems(void);
	__property int KeyCount = {read=GetKeyCount, nodefault};
	__property TiKeyBoardButton* KeyButton[int Index] = {read=GetKeyButton};
	
public:
	__fastcall virtual TiKeyBoard(Classes::TComponent* AOwner);
	__fastcall virtual ~TiKeyBoard(void);
	virtual void __fastcall SavePropertiesToFile(AnsiString FileName);
	virtual void __fastcall LoadPropertiesFromFile(AnsiString FileName);
	void __fastcall SetFocusHandleToActiveWindow(void);
	
__published:
	__property Qgraphics::TFont* Font = {read=FFont, write=SetFont};
	__property int OuterMargin = {read=FOuterMargin, write=SetOuterMargin, nodefault};
	__property int SecondRowMargin = {read=FSecondRowMargin, write=SetSecondRowMargin, nodefault};
	__property TiKeyBoardStyle Style = {read=FStyle, write=SetStyle, nodefault};
	__property BackGroundColor  = {default=-2};
	__property BorderStyle  = {default=0};
	__property Width  = {default=115};
	__property Height  = {default=140};
	__property int FocusHandle = {read=FFocusHandle, write=SetFocusHandle, nodefault};
public:
	#pragma option push -w-inl
	/* TWidgetControl.CreateParented */ inline __fastcall TiKeyBoard(Qt::QWidgetH* ParentWidget) : Qicustomcomponent::TiCustomComponent(ParentWidget) { }
	#pragma option pop
	
};


//-- var, const, procedure ---------------------------------------------------

}	/* namespace Qikeyboard */
using namespace Qikeyboard;
#pragma option pop	// -w-
#pragma option pop	// -Vx

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// QiKeyBoard
