{ File: OEReg.Pas                                                    }
{ Description: ODBCExpress Registration Unit                         }
{ Author: Korbitec                                                   }
{ Copyright: Korbitec (Pty) Ltd                                      }
{                                                                    }

unit OEReg;

{$ObjExportAll On}

interface

uses
  Classes, DesignIntf, OCIH, OCL, OVCL, ODSI, ExtVCs, ExtGrid, OEProp;

{ Register }
procedure Register;

implementation

{ Register }

procedure Register;
const
  OEPage = 'ODBCExpress';
begin
  { OE Handle Components }
  RegisterComponents(OEPage, [THdbc, TOEDataSet, TOEQuery, THstmt]);
  RegisterPropertyEditor(TypeInfo(String), THdbc, 'Driver',
    TDriverEditor);
  RegisterPropertyEditor(TypeInfo(String), THdbc, 'DataSource',
    TDataSourceEditor);
  RegisterPropertyEditor(TypeInfo(SQLUINTEGER), THdbc, 'IsolationLevel',
    TIsolationLevelEditor);
  RegisterPropertyEditor(TypeInfo(SQLUSMALLINT), THdbc, 'InfoPrompt',
    TInfoPromptEditor);
  RegisterPropertyEditor(TypeInfo(SQLUINTEGER), THdbc, 'CursorLib',
    TCursorLibEditor);
  RegisterPropertyEditor(TypeInfo(String), THdbc, 'Version',
    TVersionEditor);
  RegisterPropertyEditor(TypeInfo(String), THstmt, 'SQL',
    TSQLEditor);
  RegisterComponentEditor(THstmt, TSQLEditorPopup);
  RegisterPropertyEditor(TypeInfo(SQLUINTEGER), THstmt, 'ConcurrencyType',
    TConcurrencyTypeEditor);
  RegisterPropertyEditor(TypeInfo(SQLUINTEGER), THstmt, 'CursorType',
    TCursorTypeEditor);
  RegisterPropertyEditor(TypeInfo(TStrings), TCustomOEQuery, 'SQL',
    TSQLEditor);

  { OE DataSet Components }
  RegisterPropertyEditor(TypeInfo(String), TCustomOEDataSet, 'SQL',
    TSQLEditor);
  RegisterPropertyEditor(TypeInfo(String), TCustomOEDataSet, 'Table',
    TTableEditor);
  RegisterPropertyEditor(TypeInfo(String), TCustomOEDataSet, 'StoredProc',
    TStoredProcEditor);
  RegisterPropertyEditor(TypeInfo(SQLUINTEGER), TDataSetHstmt, 'ConcurrencyType',
    TConcurrencyTypeEditor);
  RegisterPropertyEditor(TypeInfo(SQLUINTEGER), TDataSetHstmt, 'CursorType',
    TCursorTypeEditor);
  RegisterPropertyEditor(TypeInfo(TTarget), TDataSetHstmt, 'Target',
    TTargetEditor);
  RegisterPropertyEditor(TypeInfo(String), TCustomOEQuery, 'TableName',
    TTableEditor);
  RegisterPropertyEditor(TypeInfo(String), TCustomOEQuery, 'StoredProcName',
    TStoredProcEditor);

  { OE Update Components }
  RegisterComponents(OEPage, [TOEUpdateSQL, TOEUpdateProc]);
  RegisterPropertyEditor(TypeInfo(TStrings), TOEUpdateSQL, 'InsertSQL',
    TSQLEditor);
  RegisterPropertyEditor(TypeInfo(TStrings), TOEUpdateSQL, 'ModifySQL',
    TSQLEditor);
  RegisterPropertyEditor(TypeInfo(TStrings), TOEUpdateSQL, 'DeleteSQL',
    TSQLEditor);
  RegisterPropertyEditor(TypeInfo(String), TOEUpdateProc, 'InsertProc',
    TStoredProcEditor);
  RegisterPropertyEditor(TypeInfo(String), TOEUpdateProc, 'ModifyProc',
    TStoredProcEditor);
  RegisterPropertyEditor(TypeInfo(String), TOEUpdateProc, 'DeleteProc',
    TStoredProcEditor);

  { OE Non-Visual Components }
  RegisterComponents(OEPage, [TOESchema, TOECatalog, TOEBulkCopy, TOEAdministrator]);
  RegisterPropertyEditor(TypeInfo(TSchemaTables), TOESchema, 'Tables',
    TSchemaPropertyEditor);
  RegisterPropertyEditor(TypeInfo(TSchemaViews), TOESchema, 'Views',
    TSchemaPropertyEditor);
  RegisterComponentEditor(TOESchema, TSchemaEditorPopup);
  RegisterPropertyEditor(TypeInfo(String), TOEBulkCopy, 'SQLSource',
    TSQLEditor);
  RegisterPropertyEditor(TypeInfo(String), TOEBulkCopy, 'SQLTarget',
    TSQLEditor);
  RegisterPropertyEditor(TypeInfo(String), TOEAdministrator, 'Driver',
    TDriverEditor);
  RegisterPropertyEditor(TypeInfo(String), TOEAdministrator, 'DataSource',
    TDataSourceEditor);

  { OE Visual Controls }
  RegisterComponents(OEPage, [TDSComboBox, TDSListBox]);
end;

end.

