{ Project: OEXplore                                                  }
{ Description: ODBC Explorer                                         }
{ Author: Korbitec (Pty) Ltd                                         }
{                                                                    }

unit Unit1;

interface

uses
  Qt, SysUtils, Classes, QGraphics, QControls, QForms, QDialogs,
  QComCtrls, QExtCtrls, OCIH, OCI, OVCL, OCL, QMenus, QTypes;

type
  { TNodeType }
  TNodeType = (ntRoot, ntDataSource, ntTables, ntProcedures, ntColumns);

  { TNodePtr }
  TNodePtr = ^TNodeRec;
  TNodeRec = Record
    NodeType: TNodeType;
    Populated: Boolean;
    Hdbc: THdbc;
    Catalog: TOECatalog;
  end;

  TForm1 = class(TForm)
    TreeView1: TTreeView;
    Splitter1: TSplitter;
    ListView1: TListView;
    OEAdministrator1: TOEAdministrator;
    PopupRoot: TPopupMenu;
    PopupDataSource: TPopupMenu;
    RemoveDataSource1: TMenuItem;
    AddDataSource1: TMenuItem;
    ModifyDataSource1: TMenuItem;
    AddDataSource2: TMenuItem;
    ManageDataSources1: TMenuItem;
    RefreshDataSources1: TMenuItem;
    N1: TMenuItem;
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    DataSource1: TMenuItem;
    Exit1: TMenuItem;
    Manage1: TMenuItem;
    Refresh1: TMenuItem;
    N2: TMenuItem;
    Add1: TMenuItem;
    Modify1: TMenuItem;
    Remove1: TMenuItem;
    procedure FormShow(Sender: TObject);
    procedure TreeView1Expanding(Sender: TObject; Node: TTreeNode;
      var AllowExpansion: Boolean);
    procedure TreeView1Click(Sender: TObject);
    procedure TreeView1KeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure TreeView1MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure AddDataSource1Click(Sender: TObject);
    procedure ModifyDataSource1Click(Sender: TObject);
    procedure RemoveDataSource1Click(Sender: TObject);
    procedure ManageDataSources1Click(Sender: TObject);
    procedure RefreshDataSources1Click(Sender: TObject);
    procedure TreeView1Deletion(Sender: TObject; Node: TTreeNode);
    procedure Exit1Click(Sender: TObject);
  private
    { Private declarations }
    FRootNode: TTreeNode;

    procedure ResetAdministrator;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

uses
  Unit2;

procedure TForm1.ResetAdministrator;
begin
  with OEAdministrator1 do
  begin
    Attributes.Clear;
    DataSource:= '';
    DataSourceType:= dsDefault;
    Driver:= '';
    UserName:= '';
    Password:= '';
    Prompt:= False;
  end;
end;

procedure TForm1.FormShow(Sender: TObject);
var
  temp: TNodePtr;
begin
  FRootNode:= TreeView1.Items.AddChild(nil, 'DataSources');
  FRootNode.HasChildren:= True;

  New(temp);
  temp.NodeType:= ntRoot;
  temp.Populated:= False;

  FRootNode.Data:= temp;
end;

procedure TForm1.TreeView1Expanding(Sender: TObject;
                                    Node: TTreeNode;
                                    var AllowExpansion: Boolean);
var
  i: Integer;
  TreeNode: TTreeNode;
  temp, NodePtr: TNodePtr;
begin
  if Node <> nil then
  begin
    NodePtr:= Node.Data;
    case NodePtr.NodeType of
      ntRoot:
        if not NodePtr.Populated then
        begin
          NodePtr.Populated:= True;
          OEAdministrator1.DataSourceType:= dsDefault;
          OEAdministrator1.Refresh;
          for i:= 0 to OEAdministrator1.DataSources.Count-1 do
          begin
            TreeNode:= TreeView1.Items.AddChild(Node, OEAdministrator1.DataSources[i]);
            TreeNode.HasChildren:= True;

            New(temp);
            temp.NodeType:= ntDataSource;
            temp.Populated:= False;
            temp.Hdbc:= THdbc.Create(nil);
            temp.Hdbc.DataSource:= OEAdministrator1.DataSources[i];
            temp.Hdbc.InfoPrompt:= SQL_DRIVER_COMPLETE_REQUIRED;
            temp.Catalog:= TOECatalog.Create(nil);
            temp.Catalog.Hdbc:= temp.Hdbc;

            TreeNode.Data:= temp;
          end;
        end;
      ntDataSource:
        if not NodePtr.Populated then
        begin
          NodePtr.Populated:= True;
          NodePtr.Hdbc.Connect;

          TreeNode:= TreeView1.Items.AddChild(Node, 'Tables');
          TreeNode.HasChildren:= True;
          New(temp);
          temp.NodeType:= ntTables;
          temp.Populated:= False;
          TreeNode.Data:= temp;

          TreeNode:= TreeView1.Items.AddChild(Node, 'Procedures');
          TreeNode.HasChildren:= True;
          New(temp);
          temp.NodeType:= ntProcedures;
          temp.Populated:= False;
          TreeNode.Data:= temp;
        end;
      ntTables:
        if not NodePtr.Populated then
        begin
          NodePtr.Populated:= True;
          NodePtr:= Node.Parent.Data;
          Node.HasChildren:= NodePtr.Catalog.TableNames.Count > 0;

          for i:= 0 to NodePtr.Catalog.TableNames.Count-1 do
          begin
            TreeNode:= TreeView1.Items.AddChild(Node, NodePtr.Catalog.TableNames[i]);
            TreeNode.HasChildren:= False;

            New(temp);
            temp.NodeType:= ntColumns;
            temp.Populated:= False;

            TreeNode.Data:= temp;
          end;
        end;
      ntProcedures:
        if not NodePtr.Populated then
        begin
          NodePtr.Populated:= True;
          NodePtr:= Node.Parent.Data;
          Node.HasChildren:= NodePtr.Catalog.ProcedureNames.Count > 0;

          for i:= 0 to NodePtr.Catalog.ProcedureNames.Count-1 do
          begin
            TreeNode:= TreeView1.Items.AddChild(Node, NodePtr.Catalog.ProcedureNames[i]);
            TreeNode.HasChildren:= False;

            New(temp);
            temp.NodeType:= ntColumns;
            temp.Populated:= False;

            TreeNode.Data:= temp;
          end;
        end;
    end;
  end;
end;

procedure TForm1.TreeView1Click(Sender: TObject);
var
  i: Integer;
  NodePtr: TNodePtr;
  ListItem: TListItem;
  CatalogTable: TCatalogTable;
  CatalogProcedure: TCatalogProcedure;
begin
  Modify1.Enabled:= False;
  Remove1.Enabled:= False;

  if TreeView1.Selected <> nil then
  begin
    ListView1.Items.Clear;
    NodePtr:= TreeView1.Selected.Data;
    case NodePtr.NodeType of
      ntDataSource:
      begin
        Modify1.Enabled:= True;
        Remove1.Enabled:= True;
      end;
      ntColumns:
      begin
        NodePtr:= TreeView1.Selected.Parent.Data;
        case NodePtr.NodeType of
          ntTables:
          begin
            NodePtr:= TreeView1.Selected.Parent.Parent.Data;
            CatalogTable:= NodePtr.Catalog.TableByName('', TreeView1.Selected.Text);

            if CatalogTable <> nil then
            begin
              for i:= 0 to CatalogTable.Columns.ItemCount-1 do
              begin
                ListItem:= ListView1.Items.Add;
                ListItem.Caption:= CatalogTable.Columns[i].ColumnName;
                ListItem.SubItems.Add(CatalogTable.Columns[i].DataTypeName);
                ListItem.SubItems.Add(IntToStr(CatalogTable.Columns[i].Precision));
              end;
            end;
          end;
          ntProcedures:
          begin
            NodePtr:= TreeView1.Selected.Parent.Parent.Data;
            CatalogProcedure:= NodePtr.Catalog.ProcedureByName('', TreeView1.Selected.Text);

            if CatalogProcedure <> nil then
            begin
              for i:= 0 to CatalogProcedure.Columns.ItemCount-1 do
              begin
                ListItem:= ListView1.Items.Add;
                ListItem.Caption:= CatalogProcedure.Columns[i].ColumnName;
                ListItem.SubItems.Add(CatalogProcedure.Columns[i].DataTypeName);
                ListItem.SubItems.Add(IntToStr(CatalogProcedure.Columns[i].Precision));
              end;
            end;
          end;
        end;
      end;
    end;
  end;
end;

procedure TForm1.TreeView1KeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if (Key = KEY_UP) or (Key = KEY_DOWN) or (Key = KEY_LEFT) or (Key = KEY_RIGHT) then
    TreeView1Click(Self);
end;

procedure TForm1.TreeView1MouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
var
  NodePtr: TNodePtr;
begin
  if (TreeView1.Selected <> nil) and (Button = mbRight) then
  begin
    NodePtr:= TreeView1.Selected.Data;
    case NodePtr.NodeType of
      ntRoot:
        TreeView1.PopupMenu:= PopupRoot;
      ntDataSource:
        TreeView1.PopupMenu:= PopupDataSource;
      ntTables:
        TreeView1.PopupMenu:= nil;
      ntProcedures:
        TreeView1.PopupMenu:= nil;
      ntColumns:
        TreeView1.PopupMenu:= nil;
      else
        TreeView1.PopupMenu:= nil;
    end;
  end;
end;

procedure TForm1.AddDataSource1Click(Sender: TObject);
begin
  Form2.ListBox1.Items.Clear;
  OEAdministrator1.Refresh;
  Form2.ListBox1.Items.Assign(OEAdministrator1.Drivers);
  Form2.ListBox1.ItemIndex:= -1;
  if Form2.ShowModal = mrOK then
  begin
    ResetAdministrator;
    OEAdministrator1.Driver:= Form2.ListBox1.Items[Form2.ListBox1.ItemIndex];
    OEAdministrator1.Prompt:= True;
    if Form2.CheckBox1.Checked then
      OEAdministrator1.DataSourceType:= dsSystem
    else
      OEAdministrator1.DataSourceType:= dsUser;
    if OEAdministrator1.Add then
      RefreshDataSources1Click(Self);
  end;
end;

procedure TForm1.ModifyDataSource1Click(Sender: TObject);
var
  NodePtr: TNodePtr;
begin
  if TreeView1.Selected <> nil then
  begin
    NodePtr:= TreeView1.Selected.Data;
    if NodePtr.NodeType = ntDataSource then
    begin
      ResetAdministrator;
      OEAdministrator1.DataSource:= TreeView1.Selected.Text;
      OEAdministrator1.Driver:= OEAdministrator1.DataSourceDriver(TreeView1.Selected.Text);
      OEAdministrator1.Prompt:= True;
      if OEAdministrator1.Modify then
        RefreshDataSources1Click(Self);
    end;
  end;
end;

procedure TForm1.RemoveDataSource1Click(Sender: TObject);
var
  NodePtr: TNodePtr;
begin
  if TreeView1.Selected <> nil then
  begin
    NodePtr:= TreeView1.Selected.Data;
    if (NodePtr.NodeType = ntDataSource) and
       (MessageDLG('Remove DataSource "'+TreeView1.Selected.Text+'"?', mtConfirmation, [mbOK, mbCancel], 0) = mrOK) then
    begin
      ResetAdministrator;
      OEAdministrator1.DataSource:= TreeView1.Selected.Text;
      OEAdministrator1.Driver:= OEAdministrator1.DataSourceDriver(TreeView1.Selected.Text);
      OEAdministrator1.DataSourceType:= dsUser;  //dsSystem if removing a System DataSource
      if OEAdministrator1.Remove then
        TreeView1.Selected.Delete;
    end;
  end;
end;

procedure TForm1.ManageDataSources1Click(Sender: TObject);
begin
  if SQLManageDataSources(GlobalHenv.WinHandle) then
    RefreshDataSources1Click(Self)
  else
    ShowMessage('Unable to load ODBC DataSource Manager.');
end;

procedure TForm1.RefreshDataSources1Click(Sender: TObject);
var
  NodePtr: TNodePtr;
  AllowExpansion: Boolean;
begin
  FRootNode.DeleteChildren;
  FRootNode.HasChildren:= True;

  NodePtr:= FRootNode.Data;
  NodePtr.Populated:= False;

  AllowExpansion:= True;
  TreeView1Expanding(Self, FRootNode, AllowExpansion);
  FRootNode.Expanded:= AllowExpansion;
end;

procedure TForm1.TreeView1Deletion(Sender: TObject; Node: TTreeNode);
var
  NodePtr: TNodePtr;
begin
  if Node <> nil then
  begin
    NodePtr:= Node.Data;
    if NodePtr.NodeType = ntDataSource then
    begin
      Nodeptr.Catalog.Free;
      Nodeptr.Hdbc.Free;
    end;
    Dispose(NodePtr);
  end;
end;

procedure TForm1.Exit1Click(Sender: TObject);
begin
  Close;
end;

end.

