unit Unit2;

interface

uses
  Qt, SysUtils, Classes, QGraphics, QControls, QForms, QDialogs,
  DB, ODSI, OCL, OVCL;

type
  TTree = class(TDataModule)
    Hdbc1: THdbc;
    OEDataSet1: TOEDataSet;
    DataSource1: TDataSource;
    procedure OEDataSet1UpdateRecord(DataSet: TDataSet;
      UpdateKind: TUpdateKind; var ApplyUpdate: Boolean);
    procedure OEDataSet1BeforePost(DataSet: TDataSet);
    procedure OEDataSet1AfterPost(DataSet: TDataSet);
  private
    { Private declarations }
  public
    { Public declarations }
    DriverPtr: TDriverPtr;
  end;

var
  Tree: TTree;

implementation

{$R *.dfm}

procedure TTree.OEDataSet1UpdateRecord(DataSet: TDataSet;
  UpdateKind: TUpdateKind; var ApplyUpdate: Boolean);
var
  Message: String;
begin
  case UpdateKind of
    ukModify:
      Message:= 'Update record?';
    ukInsert:
      Message:= 'Insert record?';
    ukDelete:
      Message:= 'Delete record?';
  end;

  ApplyUpdate:= MessageDLG(Message, mtConfirmation, [mbOK, mbCancel], 0) = mrOK;
end;

procedure TTree.OEDataSet1BeforePost(DataSet: TDataSet);
begin
  if DriverPtr <> nil then
  begin
    Tree.Hdbc1.Core:= True;//coach on
    DriverPtr.PS_SQL_LONGVARBINARY:= 100000;
    DriverPtr.PS_SQL_LONGVARCHAR:= 100000;
  end;
end;

procedure TTree.OEDataSet1AfterPost(DataSet: TDataSet);
begin
  if DriverPtr <> nil then
    Tree.Hdbc1.Core:= False;//coach off
end;

end.

