{ Project: OEVisual                                                  }
{ Description: Delphi Data-Aware Controls                            }
{ Author: Korbitec (Pty) Ltd                                         }
{                                                                    }
{ Kylix Note: There seems to be a problem with the TDBImage control  }
{             which prevents you from inserting or updating a bitmap }
{             using the control.  To fix this problem, change the    }
{             line "FDataLink.Field.Assign(Picture.Graphic) else"    }
{             in the procedure "TDBImage.UpdateData" in the unit     }
{             "QDBCtrls" to "FDataLink.Field.Assign(Picture) else".  }
{                                                                    }

unit Unit1;

interface

uses
  Qt, SysUtils, Classes, QGraphics, QControls, QForms, QDialogs,
  QComCtrls, QExtCtrls, QStdCtrls, QDBCtrls, QMask, OCIH, OCL, OVCL, ODSI, DB;

type
  TForm1 = class(TForm)
    DBNavigator1: TDBNavigator;
    DBEdit2: TDBEdit;
    DBMemo1: TDBMemo;
    DBImage1: TDBImage;
    DBCheckBox1: TDBCheckBox;
    DBEdit1: TDBEdit;
    Button1: TButton;
    Button2: TButton;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    RadioGroup1: TRadioGroup;
    GroupBox1: TGroupBox;
    Label7: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    Label11: TLabel;
    DSComboBox1: TDSComboBox;
    Label12: TLabel;
    DBEdit3: TDBEdit;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure RadioGroup1Click(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure DSComboBox1Change(Sender: TObject);
  private
    { Private declarations }
    procedure SetControls(Enabled: Boolean);
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}
{$R GENDER.RES}

uses
  Unit2;

procedure UpdateLabel(Text: String);
begin
  Form1.Label12.Caption:= Text;
  Form1.Label12.Refresh;
end;

procedure TForm1.SetControls(Enabled: Boolean);
begin
  RadioGroup1.Enabled:= Enabled;
  Button1.Enabled:= Enabled;
  Button2.Enabled:= Enabled;
end;

procedure TForm1.FormShow(Sender: TObject);
begin
  DSComboBox1.Populate;
  DSComboBox1.ItemIndex:= -1;
  UpdateLabel('Not Connected');

  SetControls(False);
end;

procedure TForm1.DSComboBox1Change(Sender: TObject);
begin
  Tree.OEDataSet1.Close;

  if DSComboBox1.ItemIndex > -1 then
  with Tree.Hdbc1 do
  begin
    Terminate;  //reset login dialog
    DataSource:= DSComboBox1.DataSource;

    UpdateLabel('Connecting...');

    try
      Connect;
    except
      on E: EODBC do
        E.Detail('Unable to connect to database.');
    end;

    if Connected then
    begin
      UpdateLabel('Connected');

      //This driver needs a bit of couching
      Tree.DriverPtr:= nil;
      if Tree.Hdbc1.CurrentDriver = 'Microsoft SQL Server;esoobclient' then
      begin
        Tree.DriverPtr:= Tree.Hdbc1.AddDriver(Tree.Hdbc1.CurrentDriver);
        RadioGroup1.ItemIndex:= 1;
      end;

      Tree.OEDataSet1.Open;
      SetControls(True);
    end
    else
    begin
      UpdateLabel('Not Connected');
      SetControls(False);
    end;
  end;
end;

procedure TForm1.RadioGroup1Click(Sender: TObject);
var
  Hstmt: TDataSetHstmt;
begin
  Tree.OEDataSet1.Close;

  Hstmt:= Tree.OEDataSet1.Hstmt;
  case RadioGroup1.ItemIndex of
    0: begin
         { Set Positional Level }
         Hstmt.SkipByPosition:= False;
         Hstmt.SkipByCursor:= False;
         //Updatable Concurrency Needed
       end;
    1: begin
         { Set Cursor Level }
         Hstmt.SkipByPosition:= True;
         Hstmt.SkipByCursor:= False;
         //Updatable Concurrency Needed
       end;
    2: begin
         { Set Target Level }
         Hstmt.SkipByPosition:= True;
         Hstmt.SkipByCursor:= True;
         //Updatable Concurrency Not Needed
       end;
  end;

  Tree.OEDataSet1.Open;
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  Tree.OEDataSet1.Edit;
  DBImage1.Picture.Bitmap.LoadFromResourceName(HInstance, 'MALE');
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
  Tree.OEDataSet1.Edit;
  DBImage1.Picture.Bitmap.LoadFromResourceName(HInstance, 'FEMALE');
end;

end.

