{ Project: OEUpdObj                                                  }
{ Description: Update Object Components                              }
{ Author: Korbitec (Pty) Ltd                                         }
{                                                                    }

unit Unit1;

interface

uses
  Qt, SysUtils, Classes, QGraphics, QControls, QForms, QDialogs,
  QStdCtrls, QExtCtrls, QGrids, QDBGrids, QDBCtrls, DB, OCL, ODSI, OVCL;

type
  TForm1 = class(TForm)
    Hdbc1: THdbc;
    OEDataSet1: TOEDataSet;
    DataSource1: TDataSource;
    OEUpdateSQL1: TOEUpdateSQL;
    OEUpdateProc1: TOEUpdateProc;
    DataSource2: TDataSource;
    OEDataSet2: TOEDataSet;
    RadioGroup1: TRadioGroup;
    Button1: TButton;
    Button2: TButton;
    Hstmt1: THstmt;
    DBGrid1: TDBGrid;
    DBNavigator1: TDBNavigator;
    DSComboBox1: TDSComboBox;
    Label1: TLabel;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure RadioGroup1Click(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure DSComboBox1Change(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

uses
  Unit2;

procedure TForm1.Button1Click(Sender: TObject);
begin
  with Hstmt1 do
  begin
    SQL:= 'CREATE PROCEDURE CoursesInsert @Code Char(10), @Descr Char(20), @NumStuds Smallint AS'+
          '  INSERT INTO Courses (CCode, CDescr, CNumStuds) VALUES (@Code, @Descr, @NumStuds)';
    Execute;

    SQL:= 'CREATE PROCEDURE CoursesUpdate @Code Char(10), @Descr Char(20), @NumStuds Smallint AS'+
          '  UPDATE Courses SET CDescr = @Descr, CNumStuds = @NumStuds WHERE CCode = @Code';
    Execute;

    SQL:= 'CREATE PROCEDURE CoursesDelete @Code Char(10) AS'+
          '  DELETE FROM Courses WHERE CCode = @Code';
    Execute;
  end;
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
  with Hstmt1 do
  begin
    SQL:= 'DROP PROCEDURE CoursesInsert';
    Execute;

    SQL:= 'DROP PROCEDURE CoursesUpdate';
    Execute;

    SQL:= 'DROP PROCEDURE CoursesDelete';
    Execute;
  end;
end;

procedure TForm1.RadioGroup1Click(Sender: TObject);
begin
  if RadioGroup1.ItemIndex = 0 then
  begin
    OEDataSet2.Close;
    OEDataSet1.Open;
    DBGrid1.DataSource:= DataSource1;
    DBNavigator1.DataSource:= DataSource1;
  end
  else
  begin
    OEDataSet1.Close;
    OEDataSet2.Open;
    DBGrid1.DataSource:= DataSource2;
    DBNavigator1.DataSource:= DataSource2;
  end;
end;

procedure TForm1.FormShow(Sender: TObject);
begin
  DSComboBox1.Populate;
  DSComboBox1.ItemIndex:= -1;
end;

procedure TForm1.DSComboBox1Change(Sender: TObject);
begin
  Hdbc1.Terminate;

  if DSComboBox1.ItemIndex > -1 then
  begin
    Hdbc1.DataSource:= DSComboBox1.DataSource;
    Hdbc1.Connect;

    OEDataSet1.Open;
    Button1.Enabled:= True;
    Button2.Enabled:= True;
    RadioGroup1.Enabled:= True;
  end;
end;

end.

