{ Project: OESearch                                                  }
{ Description: Cancelable Queries                                    }
{ Author: Korbitec (Pty) Ltd                                         }
{                                                                    }

unit Unit1;

interface

uses
  Qt, SysUtils, Classes, QGraphics, QControls, QForms, QDialogs,
  QComCtrls, QStdCtrls, OCIH, OCI, OCL, QExtCtrls, QGrids, QDBGrids, DB, ODSI,
  OVCL;

type
  TForm1 = class(TForm)
    Hdbc1: THdbc;
    OEDataSet1: TOEDataSet;
    DataSource1: TDataSource;
    DBGrid1: TDBGrid;
    Label1: TLabel;
    Button1: TButton;
    Button3: TButton;
    ComboBox1: TComboBox;
    Button2: TButton;
    DSComboBox1: TDSComboBox;
    Label2: TLabel;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure DSComboBox1Change(Sender: TObject);
  private
    { Private declarations }
  protected
    { Protected declarations }
  public
    { Public declarations }
  published
    { Published declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

procedure TForm1.Button1Click(Sender: TObject);
begin
  if (ComboBox1.ItemIndex = -1) and (ComboBox1.Items.IndexOf(ComboBox1.Text) = -1) then
    ComboBox1.Items.Add(ComboBox1.Text);

  Button1.Enabled:= False;
  try

    OEDataSet1.Hstmt.ExecAsync:= True;

    OEDataSet1.SQL:= 'SELECT * FROM Students WHERE SComment LIKE ''%'+ComboBox1.Text+'%''';
    OEDataSet1.Open;

  finally
      Button1.Enabled:= True;
  end;
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
  OEDataSet1.AbortQuery;
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
  OEDataSet1.AbortQuery;
  Close;
end;

procedure TForm1.FormShow(Sender: TObject);
begin
  DSComboBox1.Populate;
  DSComboBox1.ItemIndex:= -1;
end;

procedure TForm1.DSComboBox1Change(Sender: TObject);
begin
  Hdbc1.Terminate;

  if DSComboBox1.ItemIndex > -1 then
  begin
    Hdbc1.DataSource:= DSComboBox1.DataSource;
    Hdbc1.Connect;

    Button1.Enabled:= True;
    Button2.Enabled:= True;
  end;
end;

end.

