{ Project: OEProc                                                    }
{ Description: Stored Procedures                                     }
{ Author: Korbitec (Pty) Ltd                                         }
{                                                                    }

unit Unit1;

interface

uses
  Qt, SysUtils, Classes, QGraphics, QControls, QForms, QDialogs,
  OCIH, OCL, QStdCtrls, Db, ODSI, QButtons, OVCL;

type
  TForm1 = class(TForm)
    Button1: TButton;
    Hstmt1: THstmt;
    Button2: TButton;
    Button3: TButton;
    Button5: TButton;
    Edit1: TEdit;
    Button6: TButton;
    Button7: TButton;
    Button8: TButton;
    Button9: TButton;
    OEDataSet1: TOEDataSet;
    Label1: TLabel;
    Hdbc1: THdbc;
    Button10: TButton;
    Button11: TButton;
    Button4: TButton;
    Button12: TButton;
    BitBtn1: TBitBtn;
    DSComboBox1: TDSComboBox;
    Label2: TLabel;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button6Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure Button7Click(Sender: TObject);
    procedure Button8Click(Sender: TObject);
    procedure Button9Click(Sender: TObject);
    procedure Button10Click(Sender: TObject);
    procedure Button11Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button12Click(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure DSComboBox1Change(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

procedure TForm1.Button1Click(Sender: TObject);
var
  SNo: String;
begin
  with Hstmt1 do
  begin
    SQL:= '{CALL TestInProc(:@StudNo)}';
    Prepare;
    SNo:= '9700001';
    BindStringByName('@StudNo', SNo);
    Execute;

    if FetchNext then
      Edit1.Text:= ColString[1];
  end;
end;

procedure TForm1.Button2Click(Sender: TObject);
var
  SName: NullString;
  ReturnVal: Integer;
begin
  with Hstmt1 do
  begin
    SQL:= '{:@RETURN_VALUE = CALL TestOutProc(:@StudName)}';
    Prepare;
    ParamType:= SQL_PARAM_OUTPUT;
    BindIntegerByName('@RETURN_VALUE', ReturnVal);
    ParamType:= SQL_PARAM_OUTPUT;
    BindNullStringByName('@StudName', SName);
    Execute;

    Edit1.Text:= SName;
  end;
end;

procedure TForm1.Button3Click(Sender: TObject);
var
  SInfo: NullString;
  ReturnVal: Integer;  
begin
  with Hstmt1 do
  begin
    SQL:= '{:@RETURN_VALUE = CALL TestInOutProc(:@StudInfo)}';
    Prepare;
    ParamType:= SQL_PARAM_OUTPUT;
    BindIntegerByName('@RETURN_VALUE', ReturnVal);
    ParamType:= SQL_PARAM_INPUT_OUTPUT;
    SInfo:= '9700003';
    BindNullStringByName('@StudInfo', SInfo);
    Execute;

    Edit1.Text:= SInfo;
  end;
end;

procedure TForm1.Button6Click(Sender: TObject);
begin
  with Hstmt1 do
  begin
    SQL:=
      'CREATE PROCEDURE TestInProc @StudNo CHAR(10) AS '+
      '  SELECT SName AS "Student Name" FROM Students WHERE SNo = @StudNo';
    Execute;

    SQL:=
      'CREATE PROCEDURE TestOutProc @StudName CHAR(20) OUTPUT AS '+
      '  SELECT @StudName = SName FROM Students WHERE SNo = ''9700002''';
    Execute;

    SQL:=
      'CREATE PROCEDURE TestInOutProc @StudInfo CHAR(20) OUTPUT AS '+
      '  SELECT @StudInfo = SName FROM Students WHERE SNo = @StudInfo';
    Execute;

    SQL:=
      'CREATE PROCEDURE TestReturnProc @Code CHAR(10), @Descr CHAR(20), @NumStuds INT AS '+
      '  INSERT INTO Courses (CCode, CDescr, CNumStuds) VALUES (@Code, @Descr, @NumStuds) '+
      '  RETURN @NumStuds';
    Execute;
  end;
end;

procedure TForm1.Button5Click(Sender: TObject);
begin
  with Hstmt1 do
  begin
    SQL:= 'DROP PROCEDURE TestInProc';
    Execute;

    SQL:= 'DROP PROCEDURE TestOutProc';
    Execute;

    SQL:= 'DROP PROCEDURE TestInOutProc';
    Execute;

    SQL:= 'DROP PROCEDURE TestReturnProc';
    Execute;
  end;
end;

procedure TForm1.Button7Click(Sender: TObject);
begin
  with OEDataSet1 do
  begin
    StoredProc:= 'TestInProc';
    ParamByName('@StudNo').AsString:= '9700001';
    Open;

    Edit1.Text:= Fields[0].AsString;
    Close;
  end;
end;

procedure TForm1.Button8Click(Sender: TObject);
begin
  with OEDataSet1 do
  begin
    StoredProc:= 'TestOutProc';
    ExecSQL;

    Edit1.Text:= ParamByName('@StudName').AsString;
  end;
end;

procedure TForm1.Button9Click(Sender: TObject);
begin
  with OEDataSet1 do
  begin
    StoredProc:= 'TestInOutProc';
    ParamByName('@StudInfo').AsString:= '9700003';
    ExecSQL;

    Edit1.Text:= ParamByName('@StudInfo').AsString;
  end;
end;

procedure TForm1.Button10Click(Sender: TObject);
var
  CCode, CDescr: String;
  CNumStuds, ReturnVal: Integer;
begin
  with Hstmt1 do
  begin
    SQL:= 'DELETE FROM Courses WHERE CCode = ''WR4''';
    Execute;

    SQL:= '{:@RETURN_VALUE = CALL TestReturnProc(:@Code, :@Descr, :@NumStuds)}';
    Prepare;
    CCode:= 'WR4';
    CDescr:= 'Computer Science 4';
    CNumStuds:= 10;
    ParamType:= SQL_PARAM_OUTPUT;
    BindIntegerByName('@RETURN_VALUE', ReturnVal);
    BindIntegerByName('@NumStuds', CNumStuds);
    BindStringByName('@Descr', CDescr);
    BindStringByName('@Code', CCode);
    Execute;
    MoreResults;

    Edit1.Text:= IntToStr(ReturnVal);
  end;
end;

procedure TForm1.Button4Click(Sender: TObject);
begin
  with Hstmt1 do
  begin
    SQL:= 'DELETE FROM Courses WHERE CCode = ''WR4''';
    Execute;
  end;

  with OEDataSet1 do
  begin
    StoredProc:= 'TestReturnProc';
    ParamByName('@Code').AsString:= 'WR4';
    ParamByName('@Descr').AsString:= 'Computer Science 4';
    ParamByName('@NumStuds').AsInteger:= 11;
    ExecSQL;
    NextResultSet;

    Edit1.Text:= ParamByName('@RETURN_VALUE').AsString;
  end;
end;

procedure TForm1.Button11Click(Sender: TObject);
var
  CCode, CDescr: String;
  CNumStuds, ReturnVal: Integer;
begin
  with Hstmt1 do
  begin
    SQL:= 'DELETE FROM Courses WHERE CCode = ''WR4''';
    Execute;

    BindByName:= True;

    SQL:= '{:@RETURN_VALUE = CALL TestReturnProc(:@NumStuds, :@Descr, :@Code)}';
    Prepare;
    CCode:= 'WR4';
    CDescr:= 'Computer Science 4';
    CNumStuds:= 12;
    ParamType:= SQL_PARAM_OUTPUT;
    BindIntegerByName('@RETURN_VALUE', ReturnVal);
    BindIntegerByName('@NumStuds', CNumStuds);
    BindStringByName('@Descr', CDescr);
    BindStringByName('@Code', CCode);
    Execute;
    MoreResults;

    Edit1.Text:= IntToStr(ReturnVal);

    BindByName:= False;
  end;
end;

procedure TForm1.Button12Click(Sender: TObject);
begin
  with Hstmt1 do
  begin
    SQL:= 'DELETE FROM Courses WHERE CCode = ''WR4''';
    Execute;
  end;

  with OEDataSet1 do
  begin
    Hstmt.BindByName:= True;

    StoredProc:= 'TestReturnProc';
    ParamByName('@Code').AsString:= 'WR4';
    ParamByName('@Descr').AsString:= 'Computer Science 4';
    ParamByName('@NumStuds').AsInteger:= 13;
    ExecSQL;
    NextResultSet;

    Edit1.Text:= ParamByName('@RETURN_VALUE').AsString;

    Hstmt.BindByName:= False;
  end;
end;

procedure TForm1.FormShow(Sender: TObject);
begin
  DSComboBox1.Populate;
  DSComboBox1.ItemIndex:= -1;
end;

procedure TForm1.DSComboBox1Change(Sender: TObject);
begin
  Hdbc1.Terminate;

  if DSComboBox1.ItemIndex > -1 then
  begin
    Hdbc1.DataSource:= DSComboBox1.DataSource;
    Hdbc1.Connect;

    Button5.Enabled:= True;
    Button6.Enabled:= True;
  end;
end;

end.

