{ Project: OEMstDet                                                  }
{ Description: Master-Detail Relationship                            }
{ Author: Korbitec (Pty) Ltd                                         }
{                                                                    }

unit Unit1;

interface

uses
  Qt, SysUtils, Classes, QGraphics, QControls, QForms, QDialogs,
  QExtCtrls, QDBCtrls, QGrids, QDBGrids, DB, OCL, ODSI, QStdCtrls, OVCL;

type
  TForm1 = class(TForm)
    Hdbc1: THdbc;
    OEDataSet1: TOEDataSet;
    OEDataSet2: TOEDataSet;
    DataSource1: TDataSource;
    DataSource2: TDataSource;
    DBGrid1: TDBGrid;
    DBGrid2: TDBGrid;
    Label11: TLabel;
    DSComboBox1: TDSComboBox;
    procedure FormShow(Sender: TObject);
    procedure DSComboBox1Change(Sender: TObject);
    procedure DBGrid1KeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure DBGrid2KeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure OEDataSet2AfterInsert(DataSet: TDataSet);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

procedure TForm1.FormShow(Sender: TObject);
begin
  DSComboBox1.Populate;
  DSComboBox1.ItemIndex:= -1;
end;

procedure TForm1.DSComboBox1Change(Sender: TObject);
begin
  OEDataSet1.Close;
  OEDataSet2.Close;

  if DSComboBox1.ItemIndex > -1 then
  with Hdbc1 do
  begin
    Terminate;  //reset login dialog
    DataSource:= DSComboBox1.DataSource;

    try
      Connect;
    except
      on E: EODBC do
        E.Detail('Unable to connect to database.');
    end;

    if Connected then
    begin
      OEDataSet1.Open;
      OEDataSet2.Open;
    end;
  end;
end;

procedure TForm1.DBGrid1KeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if (Key = KEY_DELETE) and (not (OEDataSet1.State in [dsEdit, dsInsert])) then
    OEDataSet1.Delete;
end;

procedure TForm1.DBGrid2KeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if (Key = KEY_DELETE) and (not (OEDataSet2.State in [dsEdit, dsInsert])) then
    OEDataSet2.Delete;
end;

procedure TForm1.OEDataSet2AfterInsert(DataSet: TDataSet);
begin
  OEDataSet2.FieldByName('SNo').AsString:= OEDataSet1.FieldByName('SNo').AsString;
end;

end.

